/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.common.impl.lc;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.gcontracts.common.base.BaseLifecycle;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.generation.PreconditionGenerator;

public class PreconditionLifecycle
extends BaseLifecycle {
    public void beforeProcessingContructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
        this.generatePrecondition(processingContextInformation, classNode, constructorNode);
    }

    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        this.generatePrecondition(processingContextInformation, classNode, methodNode);
    }

    private void generatePrecondition(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        if (!processingContextInformation.isPreconditionsEnabled()) {
            return;
        }
        if (!CandidateChecks.isPreconditionCandidate(classNode, methodNode)) {
            return;
        }
        if (processingContextInformation.contract().preconditions().contains(methodNode)) {
            return;
        }
        PreconditionGenerator preconditionGenerator = new PreconditionGenerator(processingContextInformation.readerSource());
        preconditionGenerator.generateDefaultPreconditionStatement(classNode, methodNode);
    }
}

