/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.classgen.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.Verifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureWriter {
    private int closureCount = 1;

    public ClassNode createClosureClass(ClassNode classNode, MethodNode methodNode, ClosureExpression expression, boolean addOldVariable, boolean addResultVariable, int mods) {
        Parameter[] parameters;
        ClassNode outerClass = this.getOutermostClass(classNode);
        String name = outerClass.getName() + "$" + this.getClosureInnerName(outerClass, classNode);
        ArrayList<Parameter> parametersTemp = new ArrayList<Parameter>(Arrays.asList(expression.getParameters()));
        this.removeParameter("old", parametersTemp);
        this.removeParameter("result", parametersTemp);
        if (methodNode != null && addResultVariable && methodNode.getReturnType() != ClassHelper.VOID_TYPE) {
            parametersTemp.add(new Parameter(ClassHelper.DYNAMIC_TYPE, "result"));
        }
        if (addOldVariable) {
            parametersTemp.add(new Parameter(ClassHelper.DYNAMIC_TYPE, "old"));
        }
        if ((parameters = parametersTemp.toArray(new Parameter[parametersTemp.size()])) == null) {
            parameters = Parameter.EMPTY_ARRAY;
        } else if (parameters.length == 0) {
            Parameter it = new Parameter(ClassHelper.OBJECT_TYPE, "it", (Expression)ConstantExpression.NULL);
            parameters = new Parameter[]{it};
            Variable ref = expression.getVariableScope().getDeclaredVariable("it");
            if (ref != null) {
                it.setClosureSharedVariable(ref.isClosureSharedVariable());
            }
        }
        Parameter[] localVariableParams = this.getClosureSharedVariables(expression);
        this.removeInitialValues(localVariableParams);
        InnerClassNode answer = new InnerClassNode(outerClass, name, mods, ClassHelper.CLOSURE_TYPE.getPlainNodeReference());
        answer.setEnclosingMethod(null);
        answer.setSynthetic(true);
        answer.setUsingGenerics(outerClass.isUsingGenerics());
        MethodNode method = answer.addMethod("doCall", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, expression.getCode());
        method.setSourcePosition((ASTNode)expression);
        VariableScope varScope = expression.getVariableScope();
        if (varScope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression + " class: " + name);
        }
        method.setVariableScope(varScope.copy());
        if (parameters.length > 1 || parameters.length == 1 && parameters[0].getType() != null && parameters[0].getType() != ClassHelper.OBJECT_TYPE) {
            MethodNode call = answer.addMethod("call", 1, ClassHelper.OBJECT_TYPE, parameters, ClassNode.EMPTY_ARRAY, (Statement)new ReturnStatement((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "doCall", (Expression)new ArgumentListExpression(parameters))));
            call.setSourcePosition((ASTNode)expression);
        }
        BlockStatement block = new BlockStatement();
        VariableExpression outer = new VariableExpression("_outerInstance");
        outer.setSourcePosition((ASTNode)expression);
        block.getVariableScope().putReferencedLocalVariable((Variable)outer);
        VariableExpression thisObject = new VariableExpression("_thisObject");
        thisObject.setSourcePosition((ASTNode)expression);
        block.getVariableScope().putReferencedLocalVariable((Variable)thisObject);
        TupleExpression conArgs = new TupleExpression((Expression)outer, (Expression)thisObject);
        block.addStatement((Statement)new ExpressionStatement((Expression)new ConstructorCallExpression(ClassNode.SUPER, (Expression)conArgs)));
        for (Parameter param : localVariableParams) {
            String paramName = param.getName();
            ClassNode type = param.getType();
            VariableExpression initialValue = new VariableExpression(paramName);
            initialValue.setAccessedVariable((Variable)param);
            initialValue.setUseReferenceDirectly(true);
            ClassNode realType = type;
            type = ClassHelper.makeReference();
            param.setType(ClassHelper.makeReference());
            FieldNode paramField = answer.addField(paramName, 4098, type, (Expression)initialValue);
            paramField.setDeclaringClass(ClassHelper.getWrapper((ClassNode)param.getOriginType()));
            paramField.setHolder(true);
            String methodName = Verifier.capitalize((String)paramName);
            FieldExpression fieldExp = new FieldExpression(paramField);
            answer.addMethod("get" + methodName, 1, realType, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, (Statement)new ReturnStatement((Expression)fieldExp));
        }
        Parameter[] params = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "_outerInstance"), new Parameter(ClassHelper.OBJECT_TYPE, "_thisObject")};
        ConstructorNode sn = answer.addConstructor(1, params, ClassNode.EMPTY_ARRAY, (Statement)block);
        sn.setSourcePosition((ASTNode)expression);
        this.correctAccessedVariable(answer, expression);
        return answer;
    }

    private void removeParameter(String name, List<Parameter> parameters) {
        Iterator<Parameter> it = parameters.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
    }

    private ClassNode getOutermostClass(ClassNode outermostClass) {
        while (outermostClass instanceof InnerClassNode) {
            outermostClass = outermostClass.getOuterClass();
        }
        return outermostClass;
    }

    private Parameter[] getClosureSharedVariables(ClosureExpression ce) {
        VariableScope scope = ce.getVariableScope();
        Parameter[] ret = new Parameter[scope.getReferencedLocalVariablesCount()];
        int index = 0;
        Iterator iter = scope.getReferencedLocalVariablesIterator();
        while (iter.hasNext()) {
            Variable element = (Variable)iter.next();
            Parameter p = new Parameter(element.getType(), element.getName());
            p.setDeclaringClass(element.getOriginType());
            p.setClosureSharedVariable(element.isClosureSharedVariable());
            ret[index] = p;
            ++index;
        }
        return ret;
    }

    private void removeInitialValues(Parameter[] params) {
        for (int i = 0; i < params.length; ++i) {
            if (!params[i].hasInitialExpression()) continue;
            Parameter p = new Parameter(params[i].getType(), params[i].getName());
            p.setDeclaringClass(p.getOriginType());
            params[i] = p;
        }
    }

    private void correctAccessedVariable(final InnerClassNode closureClass, ClosureExpression ce) {
        CodeVisitorSupport visitor = new CodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression expression) {
                Variable v = expression.getAccessedVariable();
                if (v == null) {
                    return;
                }
                if (!(v instanceof FieldNode)) {
                    return;
                }
                String name = expression.getName();
                FieldNode fn = closureClass.getDeclaredField(name);
                expression.setAccessedVariable((Variable)fn);
            }
        };
        visitor.visitClosureExpression(ce);
    }

    private String getClosureInnerName(ClassNode owner, ClassNode enclosingClass) {
        String ownerShortName = owner.getNameWithoutPackage();
        String classShortName = enclosingClass.getNameWithoutPackage();
        classShortName = classShortName.equals(ownerShortName) ? "" : classShortName + "_";
        int dp = classShortName.lastIndexOf("$");
        if (dp >= 0) {
            classShortName = classShortName.substring(++dp);
        }
        if (classShortName.startsWith("_")) {
            classShortName = classShortName.substring(1);
        }
        return "_gc_" + classShortName + "closure" + this.closureCount++;
    }
}

