/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.gcontracts.annotations.Contracted;
import org.gcontracts.annotations.meta.AnnotationContract;
import org.gcontracts.ast.BaseASTTransformation;
import org.gcontracts.ast.visitor.AnnotationClosureVisitor;
import org.gcontracts.ast.visitor.AnnotationProcessorVisitor;
import org.gcontracts.ast.visitor.ConfiguratorSetupVisitor;
import org.gcontracts.ast.visitor.ContractElementVisitor;
import org.gcontracts.ast.visitor.DomainModelInjectionVisitor;
import org.gcontracts.ast.visitor.DynamicSetterInjectionVisitor;
import org.gcontracts.ast.visitor.LifecycleAfterTransformationVisitor;
import org.gcontracts.ast.visitor.LifecycleBeforeTransformationVisitor;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.util.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GContractsASTTransformation
extends BaseASTTransformation {
    private void generateAnnotationClosureClasses(SourceUnit unit, ReaderSource source, List<ClassNode> classNodes) {
        AnnotationClosureVisitor annotationClosureVisitor = new AnnotationClosureVisitor(unit, source);
        for (ClassNode classNode : classNodes) {
            annotationClosureVisitor.visitClass(classNode);
        }
    }

    public void visit(ASTNode[] nodes, SourceUnit unit) {
        ModuleNode moduleNode = unit.getAST();
        ReaderSource source = this.getReaderSource(unit);
        ArrayList<ClassNode> classNodes = new ArrayList<ClassNode>(moduleNode.getClasses());
        this.generateAnnotationClosureClasses(unit, source, classNodes);
        ConfiguratorSetupVisitor configuratorSetupVisitor = new ConfiguratorSetupVisitor(unit, source);
        for (ClassNode classNode : moduleNode.getClasses()) {
            if (CandidateChecks.isAnnotationContractCandidate(classNode) && AnnotationUtils.hasAnnotationOfType((AnnotatedNode)classNode, AnnotationContract.class.getName())) {
                this.markAnnotationContract(classNode);
            }
            if (!CandidateChecks.isContractsCandidate(classNode)) continue;
            ContractElementVisitor contractElementVisitor = new ContractElementVisitor(unit, source);
            contractElementVisitor.visitClass(classNode);
            if (!contractElementVisitor.isFoundContractElement()) continue;
            ProcessingContextInformation pci = new ProcessingContextInformation(classNode, unit, source);
            configuratorSetupVisitor.visitClass(classNode);
            this.markClassNodeAsContracted(classNode);
            new LifecycleBeforeTransformationVisitor(unit, source, pci).visitClass(classNode);
            new AnnotationProcessorVisitor(unit, source, pci).visitClass(classNode);
            new DomainModelInjectionVisitor(unit, source, pci).visitClass(classNode);
            new LifecycleAfterTransformationVisitor(unit, source, pci).visitClass(classNode);
            new DynamicSetterInjectionVisitor(unit, source).visitClass(classNode);
        }
    }

    private void markClassNodeAsContracted(ClassNode classNode) {
        ClassNode contractedAnnotationClassNode = ClassHelper.makeWithoutCaching(Contracted.class);
        classNode.addAnnotation(new AnnotationNode(contractedAnnotationClassNode));
    }

    private void markAnnotationContract(ClassNode classNode) {
        ClassNode retentionClassNode = ClassHelper.makeWithoutCaching(Retention.class);
        AnnotationNode retentionAnnotationNode = new AnnotationNode(retentionClassNode);
        retentionAnnotationNode.addMember("value", (Expression)new PropertyExpression((Expression)new ClassExpression(ClassHelper.makeWithoutCaching(RetentionPolicy.class)), "RUNTIME"));
        ClassNode targetClassNode = ClassHelper.makeWithoutCaching(Target.class);
        AnnotationNode targetAnnotationNode = new AnnotationNode(targetClassNode);
        targetAnnotationNode.addMember("value", (Expression)new PropertyExpression((Expression)new ClassExpression(ClassHelper.makeWithoutCaching(ElementType.class)), "PARAMETER"));
        classNode.addAnnotation(retentionAnnotationNode);
        classNode.addAnnotation(targetAnnotationNode);
    }
}

