/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.objectweb.asm.Opcodes;

public class ExpressionUtils {
    public static List<BooleanExpression> getBooleanExpression(ClosureExpression closureExpression) {
        if (closureExpression == null) {
            return null;
        }
        BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
        return ExpressionUtils.getBooleanExpressions(closureBlockStatement);
    }

    private static List<BooleanExpression> getBooleanExpressions(BlockStatement closureBlockStatement) {
        List statementList = closureBlockStatement.getStatements();
        ArrayList<BooleanExpression> booleanExpressions = new ArrayList<BooleanExpression>();
        for (Statement stmt : statementList) {
            BooleanExpression tmp = null;
            if (stmt instanceof ExpressionStatement && ((ExpressionStatement)stmt).getExpression() instanceof BooleanExpression) {
                tmp = (BooleanExpression)((ExpressionStatement)stmt).getExpression();
                tmp.setNodeMetaData((Object)"statementLabel", (Object)stmt.getStatementLabel());
            } else if (stmt instanceof ExpressionStatement) {
                Expression expression = ((ExpressionStatement)stmt).getExpression();
                tmp = new BooleanExpression(expression);
                tmp.setSourcePosition((ASTNode)expression);
                tmp.setNodeMetaData((Object)"statementLabel", (Object)stmt.getStatementLabel());
            }
            booleanExpressions.add(tmp);
        }
        return booleanExpressions;
    }

    public static List<BooleanExpression> getBooleanExpressionsFromAssertionStatements(BlockStatement blockStatement) {
        AssertStatementCollector collector = new AssertStatementCollector();
        collector.visitBlockStatement(blockStatement);
        List<AssertStatement> assertStatements = collector.assertStatements;
        if (assertStatements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BooleanExpression> booleanExpressions = new ArrayList<BooleanExpression>();
        for (AssertStatement assertStatement : assertStatements) {
            booleanExpressions.add(assertStatement.getBooleanExpression());
        }
        return booleanExpressions;
    }

    public static BooleanExpression getBooleanExpression(List<BooleanExpression> booleanExpressions) {
        if (booleanExpressions == null || booleanExpressions.isEmpty()) {
            return new BooleanExpression((Expression)ConstantExpression.TRUE);
        }
        BooleanExpression result = null;
        for (BooleanExpression booleanExpression : booleanExpressions) {
            if (result == null) {
                result = booleanExpression;
                continue;
            }
            result = new BooleanExpression((Expression)new BinaryExpression((Expression)result, Token.newSymbol((int)164, (int)-1, (int)-1), (Expression)booleanExpression));
        }
        return result;
    }

    static class AssertStatementCollector
    extends ClassCodeVisitorSupport
    implements Opcodes {
        public List<AssertStatement> assertStatements = new ArrayList<AssertStatement>();

        AssertStatementCollector() {
        }

        public void visitAssertStatement(AssertStatement statement) {
            this.assertStatements.add(statement);
        }

        protected SourceUnit getSourceUnit() {
            return null;
        }
    }
}

