/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.util;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.gcontracts.generation.CandidateChecks;

public class AnnotationUtils {
    public static boolean hasAnnotationOfType(AnnotatedNode annotatedNode, String typeOrPackageName) {
        for (AnnotationNode annotation : annotatedNode.getAnnotations()) {
            if (!annotation.getClassNode().getName().startsWith(typeOrPackageName)) continue;
            return true;
        }
        return false;
    }

    public static List<AnnotationNode> getAnnotationNodeInHierarchyWithMetaAnnotation(ClassNode type, ClassNode anno) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        for (AnnotationNode annotation : type.getAnnotations()) {
            if (annotation.getClassNode().getAnnotations(anno).size() <= 0) continue;
            result.add(annotation);
        }
        if (result.isEmpty() && type.getSuperClass() != null) {
            return AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), anno);
        }
        return result;
    }

    public static List<AnnotationNode> getAnnotationNodeInHierarchyWithMetaAnnotation(ClassNode type, MethodNode originMethodNode, ClassNode metaAnnotationClassNode) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        while (type != null) {
            MethodNode methodNode = type.getMethod(originMethodNode.getName(), originMethodNode.getParameters());
            if (methodNode != null) {
                for (AnnotationNode annotation : methodNode.getAnnotations()) {
                    if (annotation.getClassNode().getAnnotations(metaAnnotationClassNode).size() <= 0) continue;
                    result.add(annotation);
                }
                if (result.size() > 0) {
                    return result;
                }
            }
            type = type.getSuperClass();
        }
        return result;
    }

    public static List<AnnotationNode> hasMetaAnnotations(AnnotatedNode annotatedNode, String metaAnnotationClassName) {
        ArrayList<AnnotationNode> result = new ArrayList<AnnotationNode>();
        for (AnnotationNode annotationNode : annotatedNode.getAnnotations()) {
            if (CandidateChecks.isRuntimeClass(annotationNode.getClassNode())) continue;
            List<AnnotationNode> metaAnnotations = annotationNode.getClassNode().getAnnotations(ClassHelper.makeWithoutCaching((String)metaAnnotationClassName));
            if (metaAnnotations.isEmpty()) {
                metaAnnotations = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)annotationNode.getClassNode(), metaAnnotationClassName);
            }
            if (metaAnnotations.size() <= 0) continue;
            result.add(annotationNode);
        }
        return result;
    }
}

