/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.domain.Postcondition;
import org.gcontracts.generation.AssertStatementCreationUtility;
import org.gcontracts.generation.BaseGenerator;
import org.gcontracts.generation.OldVariableGenerationUtility;
import org.gcontracts.util.AnnotationUtils;

public class PostconditionGenerator
extends BaseGenerator {
    public PostconditionGenerator(ReaderSource source) {
        super(source);
    }

    public void addOldVariablesMethod(ClassNode classNode) {
        OldVariableGenerationUtility.addOldVariableMethodNode(classNode);
    }

    public void generatePostconditionAssertionStatement(MethodNode method, Postcondition postcondition) {
        BooleanExpression postconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, org.gcontracts.annotations.meta.Postcondition.class, postcondition.booleanExpression(), true);
        BlockStatement originalBlockStatement = postcondition.originalBlockStatement();
        boolean useExecutionTracker = originalBlockStatement == null || Boolean.TRUE.equals(originalBlockStatement.getNodeMetaData((Object)"org.gcontracts.META_DATA.USE_EXECUTION_TRACKER"));
        BlockStatement blockStatement = !useExecutionTracker && Boolean.TRUE.equals(method.getNodeMetaData((Object)"org.gcontracts.USE_INLINE_MODE")) ? this.getInlineModeBlockStatement(originalBlockStatement) : this.wrapAssertionBooleanExpression(method.getDeclaringClass(), method, postconditionBooleanExpression, "postcondition");
        this.addPostcondition(method, blockStatement);
    }

    public void generateDefaultPostconditionStatement(ClassNode type, MethodNode method) {
        boolean isAnotherPostconditionAvailable;
        boolean bl = isAnotherPostconditionAvailable = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), method, ClassHelper.makeWithoutCaching(org.gcontracts.annotations.meta.Postcondition.class)).size() > 0;
        if (!isAnotherPostconditionAvailable) {
            return;
        }
        BooleanExpression postconditionBooleanExpression = this.addCallsToSuperMethodNodeAnnotationClosure(method.getDeclaringClass(), method, org.gcontracts.annotations.meta.Postcondition.class, new BooleanExpression((Expression)ConstantExpression.TRUE), true);
        if (postconditionBooleanExpression.getExpression() == ConstantExpression.TRUE) {
            return;
        }
        BlockStatement blockStatement = this.wrapAssertionBooleanExpression(type, method, postconditionBooleanExpression, "postcondition");
        this.addPostcondition(method, blockStatement);
    }

    private void addPostcondition(MethodNode method, BlockStatement postconditionBlockStatement) {
        BlockStatement methodCode = (BlockStatement)method.getCode();
        List statements = methodCode.getStatements();
        if (statements.size() > 0) {
            VariableExpression enabledVariableExpression = new VariableExpression("$GCONTRACTS_ENABLED", ClassHelper.boolean_TYPE);
            enabledVariableExpression.setAccessedVariable((Variable)enabledVariableExpression);
            if (method.getReturnType() != ClassHelper.VOID_TYPE) {
                List<ReturnStatement> returnStatements = AssertStatementCreationUtility.getReturnStatements(method);
                for (ReturnStatement returnStatement : returnStatements) {
                    BlockStatement localPostconditionBlockStatement = new BlockStatement(new ArrayList(postconditionBlockStatement.getStatements()), new VariableScope());
                    VariableExpression variableExpression = new VariableExpression("result", method.getReturnType());
                    variableExpression.setAccessedVariable((Variable)variableExpression);
                    ExpressionStatement resultVariableStatement = new ExpressionStatement((Expression)new DeclarationExpression(variableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), returnStatement.getExpression()));
                    localPostconditionBlockStatement.getStatements().add(0, resultVariableStatement);
                    AssertStatementCreationUtility.injectResultVariableReturnStatementAndAssertionCallStatement(methodCode, method.getReturnType().redirect(), returnStatement, localPostconditionBlockStatement);
                }
                VariableExpression oldVariableExpression = new VariableExpression("old", new ClassNode(Map.class));
                oldVariableExpression.setAccessedVariable((Variable)oldVariableExpression);
                ExpressionStatement oldVariabeStatement = new ExpressionStatement((Expression)new BinaryExpression((Expression)oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "$_gc_computeOldVariables", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
                BlockStatement oldVariableIfBlock = new BlockStatement();
                oldVariableIfBlock.addStatement((Statement)oldVariabeStatement);
                methodCode.getStatements().add(0, new ExpressionStatement((Expression)new DeclarationExpression(oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.NULL)));
                methodCode.getStatements().add(1, new IfStatement(new BooleanExpression((Expression)enabledVariableExpression), (Statement)oldVariableIfBlock, (Statement)new BlockStatement()));
            } else if (method instanceof ConstructorNode) {
                methodCode.addStatements(postconditionBlockStatement.getStatements());
            } else {
                VariableExpression oldVariableExpression = new VariableExpression("old", new ClassNode(Map.class));
                oldVariableExpression.setAccessedVariable((Variable)oldVariableExpression);
                ExpressionStatement oldVariabeStatement = new ExpressionStatement((Expression)new BinaryExpression((Expression)oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "$_gc_computeOldVariables", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
                BlockStatement oldVariableIfBlock = new BlockStatement();
                oldVariableIfBlock.addStatement((Statement)oldVariabeStatement);
                methodCode.getStatements().add(0, new IfStatement(new BooleanExpression((Expression)enabledVariableExpression), (Statement)oldVariableIfBlock, (Statement)new BlockStatement()));
                methodCode.getStatements().add(0, new ExpressionStatement((Expression)new DeclarationExpression(oldVariableExpression, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.NULL)));
                methodCode.addStatements(postconditionBlockStatement.getStatements());
            }
        }
    }
}

