/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.util.HashSet;

public class ContractExecutionTracker {
    private static ThreadLocal<HashSet<ContractExecution>> executions = new ContractExecutionThreadLocal();

    public static boolean track(String className, String methodIdentifier, String assertionType, boolean isStatic) {
        ContractExecution ce = new ContractExecution(className, methodIdentifier, assertionType, isStatic);
        HashSet<ContractExecution> contractExecutions = executions.get();
        if (!contractExecutions.contains(ce)) {
            contractExecutions.add(ce);
            return true;
        }
        return false;
    }

    public static void clear(String className, String methodIdentifier, String assertionType, boolean isStatic) {
        HashSet<ContractExecution> contractExecutions = executions.get();
        contractExecutions.remove(new ContractExecution(className, methodIdentifier, assertionType, isStatic));
    }

    static class ContractExecutionThreadLocal
    extends ThreadLocal<HashSet<ContractExecution>> {
        ContractExecutionThreadLocal() {
        }

        @Override
        protected HashSet<ContractExecution> initialValue() {
            return new HashSet<ContractExecution>();
        }
    }

    public static final class ContractExecution {
        final String className;
        final String methodIdentifier;
        final String assertionType;
        final boolean isStatic;

        public ContractExecution(String className, String methodIdentifier, String assertionType, boolean isStatic) {
            this.className = className;
            this.methodIdentifier = methodIdentifier;
            this.assertionType = assertionType;
            this.isStatic = isStatic;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContractExecution that = (ContractExecution)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (this.assertionType != null ? !this.assertionType.equals(that.assertionType) : that.assertionType != null) {
                return false;
            }
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            return !(this.methodIdentifier != null ? !this.methodIdentifier.equals(that.methodIdentifier) : that.methodIdentifier != null);
        }

        public int hashCode() {
            int result = this.className != null ? this.className.hashCode() : 0;
            result = 31 * result + (this.methodIdentifier != null ? this.methodIdentifier.hashCode() : 0);
            result = 31 * result + (this.assertionType != null ? this.assertionType.hashCode() : 0);
            result = 31 * result + (this.isStatic ? 1 : 0);
            return result;
        }
    }
}

