/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;

public class CandidateChecks {
    public static boolean isContractsCandidate(ClassNode type) {
        return type != null && !type.isSynthetic() && !type.isInterface() && !type.isEnum() && !type.isGenericsPlaceHolder() && !type.isScript() && !type.isScriptBody() && !CandidateChecks.isRuntimeClass(type);
    }

    public static boolean isInterfaceContractsCandidate(ClassNode type) {
        return type != null && type.isInterface() && !type.isSynthetic() && !type.isEnum() && !type.isGenericsPlaceHolder() && !type.isScript() && !type.isScriptBody() && !CandidateChecks.isRuntimeClass(type);
    }

    public static boolean isClassInvariantCandidate(PropertyNode propertyNode) {
        return propertyNode != null && propertyNode.isPublic() && !propertyNode.isStatic() && !propertyNode.isInStaticContext() && !propertyNode.isClosureSharedVariable();
    }

    public static boolean isPreOrPostconditionCandidate(ClassNode type, MethodNode method) {
        return CandidateChecks.isPreconditionCandidate(type, method) || CandidateChecks.isPostconditionCandidate(type, method);
    }

    public static boolean isClassInvariantCandidate(ClassNode type, MethodNode method) {
        if (method.isSynthetic() || method.isAbstract() || method.isStatic() || !method.isPublic()) {
            return false;
        }
        return method.getDeclaringClass() == type;
    }

    public static boolean isPreconditionCandidate(ClassNode type, MethodNode method) {
        if (method.isSynthetic() || method.isAbstract()) {
            return false;
        }
        return method.getDeclaringClass() == type;
    }

    public static boolean isPostconditionCandidate(ClassNode type, MethodNode method) {
        if (!CandidateChecks.isPreconditionCandidate(type, method)) {
            return false;
        }
        return !method.isStatic();
    }

    public static boolean couldBeContractElementMethodNode(ClassNode type, MethodNode method) {
        if (method.isSynthetic() || !method.isPublic()) {
            return false;
        }
        return method.getDeclaringClass() == null || method.getDeclaringClass().getName().equals(type.getName());
    }

    public static boolean isRuntimeClass(ClassNode type) {
        return type.getName().startsWith("groovy.") || type.getName().startsWith("java.");
    }
}

