/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.ViolationTracker;
import org.gcontracts.generation.ContractExecutionTracker;
import org.gcontracts.util.AnnotationUtils;
import org.gcontracts.util.ExpressionUtils;

public abstract class BaseGenerator {
    public static final String INVARIANT_CLOSURE_PREFIX = "invariant";
    public static final String META_DATA_USE_INLINE_MODE = "org.gcontracts.USE_INLINE_MODE";
    protected final ReaderSource source;

    public BaseGenerator(ReaderSource source) {
        this.source = source;
    }

    public static String getInvariantMethodName(ClassNode classNode) {
        return "invariant_" + classNode.getName().replaceAll("\\.", "_");
    }

    public static MethodNode getInvariantMethodNode(ClassNode classNode) {
        return classNode.getDeclaredMethod(BaseGenerator.getInvariantMethodName(classNode), Parameter.EMPTY_ARRAY);
    }

    protected BlockStatement getInlineModeBlockStatement(BlockStatement blockStatement) {
        BlockStatement result = new BlockStatement();
        BooleanExpression combinedBooleanExpression = ExpressionUtils.getBooleanExpression(ExpressionUtils.getBooleanExpressionsFromAssertionStatements(blockStatement));
        BlockStatement assertionBlockStatement = new BlockStatement();
        assertionBlockStatement.addStatement((Statement)new IfStatement((BooleanExpression)new NotExpression((Expression)combinedBooleanExpression), (Statement)blockStatement, (Statement)EmptyStatement.INSTANCE));
        result.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new VariableExpression("$GCONTRACTS_ENABLED", ClassHelper.boolean_TYPE)), (Statement)assertionBlockStatement, (Statement)EmptyStatement.INSTANCE));
        return result;
    }

    protected BlockStatement wrapAssertionBooleanExpression(ClassNode type, MethodNode methodNode, BooleanExpression classInvariantExpression, String assertionType) {
        ClassNode violationTrackerClassNode = ClassHelper.makeWithoutCaching(ViolationTracker.class);
        VariableExpression $_gc_result = new VariableExpression("$_gc_result", ClassHelper.boolean_TYPE);
        $_gc_result.setAccessedVariable((Variable)$_gc_result);
        BlockStatement assertBlockStatement = new BlockStatement();
        TryCatchStatement lockTryCatchStatement = new TryCatchStatement((Statement)assertBlockStatement, (Statement)new BlockStatement(Arrays.asList(new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(ClassHelper.make(ContractExecutionTracker.class)), "clear", (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)type.getName()), new ConstantExpression((Object)methodNode.getTypeDescriptor()), new ConstantExpression((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE))))), new VariableScope()));
        BlockStatement ifBlockStatement = new BlockStatement();
        assertBlockStatement.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new MethodCallExpression((Expression)new ClassExpression(ClassHelper.make(ContractExecutionTracker.class)), "track", (Expression)new ArgumentListExpression(Arrays.asList(new ConstantExpression((Object)type.getName()), new ConstantExpression((Object)methodNode.getTypeDescriptor()), new ConstantExpression((Object)assertionType), methodNode.isStatic() ? ConstantExpression.TRUE : ConstantExpression.FALSE)))), (Statement)ifBlockStatement, (Statement)EmptyStatement.INSTANCE));
        ifBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression($_gc_result, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)ConstantExpression.FALSE)));
        ifBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "init", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        ifBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)$_gc_result, Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)classInvariantExpression)));
        BlockStatement finallyBlockStatement = new BlockStatement();
        finallyBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "deinit", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        ifBlockStatement.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new NotExpression((Expression)new MethodCallExpression((Expression)$_gc_result, "booleanValue", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS))), (Statement)new IfStatement(new BooleanExpression((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "violationsOccured", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)), (Statement)new TryCatchStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new ClassExpression(violationTrackerClassNode), "rethrowFirst", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)), (Statement)finallyBlockStatement), (Statement)EmptyStatement.INSTANCE), (Statement)EmptyStatement.INSTANCE));
        BlockStatement blockStatement = new BlockStatement();
        blockStatement.addStatement((Statement)new IfStatement(new BooleanExpression((Expression)new VariableExpression("$GCONTRACTS_ENABLED", ClassHelper.boolean_TYPE)), (Statement)lockTryCatchStatement, (Statement)EmptyStatement.INSTANCE));
        return blockStatement;
    }

    protected BooleanExpression addCallsToSuperMethodNodeAnnotationClosure(ClassNode type, MethodNode methodNode, Class<? extends Annotation> annotationType, BooleanExpression booleanExpression, boolean isPostcondition) {
        List<AnnotationNode> nextContractElementAnnotations = AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(type.getSuperClass(), methodNode, ClassHelper.makeWithoutCaching(annotationType));
        if (nextContractElementAnnotations.isEmpty()) {
            if (methodNode.getNodeMetaData((Object)META_DATA_USE_INLINE_MODE) == null) {
                methodNode.setNodeMetaData((Object)META_DATA_USE_INLINE_MODE, (Object)Boolean.TRUE);
            }
            return booleanExpression;
        }
        for (AnnotationNode nextContractElementAnnotation : nextContractElementAnnotations) {
            VariableExpression variableExpression;
            ClassExpression classExpression = (ClassExpression)nextContractElementAnnotation.getMember("value");
            if (classExpression == null) continue;
            ArgumentListExpression callArgumentList = new ArgumentListExpression();
            for (Parameter parameter : methodNode.getParameters()) {
                callArgumentList.addExpression((Expression)new VariableExpression((Variable)parameter));
            }
            if (isPostcondition && methodNode.getReturnType() != ClassHelper.VOID_TYPE && !(methodNode instanceof ConstructorNode)) {
                variableExpression = new VariableExpression("result", methodNode.getReturnType());
                variableExpression.setAccessedVariable((Variable)variableExpression);
                callArgumentList.addExpression((Expression)variableExpression);
            }
            if (isPostcondition && !(methodNode instanceof ConstructorNode)) {
                variableExpression = new VariableExpression("old", new ClassNode(Map.class));
                variableExpression.setAccessedVariable((Variable)variableExpression);
                callArgumentList.addExpression((Expression)variableExpression);
            }
            ArgumentListExpression newInstanceArguments = new ArgumentListExpression((Expression)classExpression, (Expression)new ArrayExpression(ClassHelper.DYNAMIC_TYPE, Arrays.asList(VariableExpression.THIS_EXPRESSION, VariableExpression.THIS_EXPRESSION)));
            StaticMethodCallExpression methodCallExpression = new StaticMethodCallExpression(ClassHelper.makeWithoutCaching(InvokerHelper.class), "invokeConstructorOf", (Expression)newInstanceArguments);
            MethodCallExpression doCall = new MethodCallExpression((Expression)methodCallExpression, "doCall", (Expression)callArgumentList);
            doCall.setMethodTarget((MethodNode)classExpression.getType().getMethods("doCall").get(0));
            BooleanExpression rightExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)nextContractElementAnnotation);
            booleanExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)booleanExpression, isPostcondition ? Token.newSymbol((int)164, (int)-1, (int)-1) : Token.newSymbol((int)162, (int)-1, (int)-1), (Expression)rightExpression));
        }
        return booleanExpression;
    }
}

