/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.generation;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;

public final class AssertStatementCreationUtility {
    public static BlockStatement getAssertionStatemens(List<BooleanExpression> booleanExpressions) {
        ArrayList<AssertStatement> assertStatements = new ArrayList<AssertStatement>();
        for (BooleanExpression booleanExpression : booleanExpressions) {
            assertStatements.add(AssertStatementCreationUtility.getAssertionStatement(booleanExpression));
        }
        BlockStatement blockStatement = new BlockStatement();
        blockStatement.getStatements().addAll(assertStatements);
        return blockStatement;
    }

    public static AssertStatement getAssertionStatement(BooleanExpression booleanExpression) {
        AssertStatement assertStatement = new AssertStatement(booleanExpression);
        assertStatement.setStatementLabel((String)booleanExpression.getNodeMetaData((Object)"statementLabel"));
        assertStatement.setSourcePosition((ASTNode)booleanExpression);
        return assertStatement;
    }

    public static List<ReturnStatement> getReturnStatements(MethodNode method) {
        Statement lastStatement;
        int statementCount;
        ReturnStatementVisitor returnStatementVisitor = new ReturnStatementVisitor();
        returnStatementVisitor.visitMethod(method);
        List<ReturnStatement> returnStatements = returnStatementVisitor.getReturnStatements();
        BlockStatement blockStatement = (BlockStatement)method.getCode();
        if (returnStatements.isEmpty() && (statementCount = blockStatement.getStatements().size()) > 0 && (lastStatement = (Statement)blockStatement.getStatements().get(statementCount - 1)) instanceof ExpressionStatement) {
            ReturnStatement returnStatement = new ReturnStatement((ExpressionStatement)lastStatement);
            returnStatement.setSourcePosition((ASTNode)lastStatement);
            blockStatement.getStatements().remove(lastStatement);
            blockStatement.addStatement((Statement)returnStatement);
            returnStatements.add(returnStatement);
        }
        return returnStatements;
    }

    public static void removeReturnStatement(BlockStatement statement, ReturnStatement returnStatement) {
        List statements = statement.getStatements();
        for (int i = statements.size() - 1; i >= 0; --i) {
            Statement stmt = (Statement)statements.get(i);
            if (stmt == returnStatement) {
                statements.remove(i);
                return;
            }
            if (!(stmt instanceof BlockStatement)) continue;
            AssertStatementCreationUtility.removeReturnStatement((BlockStatement)stmt, returnStatement);
            return;
        }
    }

    public static void injectResultVariableReturnStatementAndAssertionCallStatement(BlockStatement statement, ClassNode returnType, ReturnStatement returnStatement, BlockStatement assertionCallStatement) {
        AddResultReturnStatementVisitor addResultReturnStatementVisitor = new AddResultReturnStatementVisitor(returnStatement, returnType, assertionCallStatement);
        addResultReturnStatementVisitor.visitBlockStatement(statement);
    }

    public static void addAssertionCallStatementToReturnStatement(BlockStatement statement, ReturnStatement returnStatement, Statement assertionCallStatement) {
        AddAssertionCallStatementToReturnStatementVisitor addAssertionCallStatementToReturnStatementVisitor = new AddAssertionCallStatementToReturnStatementVisitor(returnStatement, assertionCallStatement);
        addAssertionCallStatementToReturnStatementVisitor.visitBlockStatement(statement);
    }

    public static class AddAssertionCallStatementToReturnStatementVisitor
    extends ClassCodeVisitorSupport {
        private BlockStatement blockStatement;
        private BlockStatement blockStatementCopy;
        private final ReturnStatement returnStatement;
        private final Statement assertionCallStatement;

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public AddAssertionCallStatementToReturnStatementVisitor(ReturnStatement returnStatement, Statement assertionCallStatement) {
            this.returnStatement = returnStatement;
            this.assertionCallStatement = assertionCallStatement;
        }

        public void visitBlockStatement(BlockStatement block) {
            this.blockStatement = block;
            this.blockStatementCopy = new BlockStatement(new ArrayList(this.blockStatement.getStatements()), this.blockStatement.getVariableScope());
            this.blockStatementCopy.copyNodeMetaData((ASTNode)this.blockStatement);
            this.blockStatementCopy.setSourcePosition((ASTNode)this.blockStatement);
            for (Statement statement : this.blockStatementCopy.getStatements()) {
                if (statement != this.returnStatement) continue;
                this.blockStatement.getStatements().remove(statement);
                VariableExpression $_gc_result = new VariableExpression("$_gc_result", ClassHelper.DYNAMIC_TYPE);
                $_gc_result.setAccessedVariable((Variable)$_gc_result);
                this.blockStatement.addStatement((Statement)new ExpressionStatement((Expression)new DeclarationExpression($_gc_result, Token.newSymbol((int)100, (int)-1, (int)-1), this.returnStatement.getExpression())));
                this.blockStatement.addStatement(this.assertionCallStatement);
                ReturnStatement gcResultReturn = new ReturnStatement((Expression)$_gc_result);
                gcResultReturn.setSourcePosition((ASTNode)this.returnStatement);
                this.blockStatement.addStatement((Statement)gcResultReturn);
                return;
            }
            super.visitBlockStatement(this.blockStatement);
        }
    }

    public static class AddResultReturnStatementVisitor
    extends ClassCodeVisitorSupport {
        private BlockStatement blockStatement;
        private BlockStatement blockStatementCopy;
        private final ReturnStatement returnStatement;
        private final ClassNode returnType;
        private final BlockStatement assertionCallStatement;

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public AddResultReturnStatementVisitor(ReturnStatement returnStatement, ClassNode returnType, BlockStatement assertionCallStatement) {
            this.returnStatement = returnStatement;
            this.returnType = returnType;
            this.assertionCallStatement = assertionCallStatement;
        }

        public void visitBlockStatement(BlockStatement block) {
            this.blockStatement = block;
            this.blockStatementCopy = new BlockStatement(new ArrayList(this.blockStatement.getStatements()), this.blockStatement.getVariableScope());
            this.blockStatementCopy.copyNodeMetaData((ASTNode)this.blockStatement);
            this.blockStatementCopy.setSourcePosition((ASTNode)this.blockStatement);
            for (Statement statement : this.blockStatementCopy.getStatements()) {
                if (statement != this.returnStatement) continue;
                this.blockStatement.getStatements().remove(statement);
                this.blockStatement.addStatements(this.assertionCallStatement.getStatements());
                VariableExpression variableExpression = new VariableExpression("result", this.returnType);
                variableExpression.setAccessedVariable((Variable)variableExpression);
                this.blockStatement.addStatement((Statement)new ReturnStatement((Expression)variableExpression));
                return;
            }
            super.visitBlockStatement(this.blockStatement);
        }
    }

    public static class ReturnStatementVisitor
    extends ClassCodeVisitorSupport {
        private List<ReturnStatement> returnStatements = new ArrayList<ReturnStatement>();

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public void visitReturnStatement(ReturnStatement statement) {
            this.returnStatements.add(statement);
        }

        public void visitClosureExpression(ClosureExpression expression) {
        }

        public List<ReturnStatement> getReturnStatements() {
            return this.returnStatements;
        }
    }
}

