/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.domain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.MethodNode;
import org.gcontracts.domain.Assertion;
import org.gcontracts.util.Validate;

public class AssertionMap<T extends Assertion<T>>
implements Iterable<Map.Entry<MethodNode, T>> {
    private final Map<MethodNode, T> internalMap = new HashMap<MethodNode, T>();

    public void and(MethodNode methodNode, T assertion) {
        Validate.notNull(methodNode);
        Validate.notNull(assertion);
        if (!this.internalMap.containsKey(methodNode)) {
            this.internalMap.put(methodNode, assertion);
        } else {
            ((Assertion)this.internalMap.get(methodNode)).and(assertion);
        }
    }

    public void or(MethodNode methodNode, T assertion) {
        Validate.notNull(methodNode);
        Validate.notNull(assertion);
        if (!this.internalMap.containsKey(methodNode)) {
            this.internalMap.put(methodNode, assertion);
        } else {
            ((Assertion)this.internalMap.get(methodNode)).or(assertion);
        }
    }

    public void join(MethodNode methodNode, T assertion) {
        this.and(methodNode, assertion);
    }

    public boolean contains(MethodNode methodNode) {
        return this.internalMap.containsKey(methodNode);
    }

    @Override
    public Iterator<Map.Entry<MethodNode, T>> iterator() {
        return this.internalMap.entrySet().iterator();
    }

    public int size() {
        return this.internalMap.size();
    }

    public T get(MethodNode methodNode) {
        return (T)((Assertion)this.internalMap.get(methodNode));
    }
}

