/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.domain;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.util.Validate;

public abstract class Assertion<T extends Assertion> {
    private BlockStatement originalBlockStatement;
    private BooleanExpression booleanExpression;

    public Assertion() {
        this.booleanExpression = new BooleanExpression((Expression)ConstantExpression.TRUE);
    }

    public Assertion(BlockStatement blockStatement, BooleanExpression booleanExpression) {
        Validate.notNull(booleanExpression);
        this.originalBlockStatement = blockStatement;
        this.booleanExpression = booleanExpression;
    }

    public BooleanExpression booleanExpression() {
        return this.booleanExpression;
    }

    public BlockStatement originalBlockStatement() {
        return this.originalBlockStatement;
    }

    public void renew(BooleanExpression booleanExpression) {
        Validate.notNull(booleanExpression);
        this.booleanExpression = booleanExpression;
    }

    public void and(T other) {
        Validate.notNull(other);
        BooleanExpression newBooleanExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)this.booleanExpression(), Token.newSymbol((int)164, (int)-1, (int)-1), (Expression)((Assertion)other).booleanExpression()));
        newBooleanExpression.setSourcePosition((ASTNode)this.booleanExpression());
        this.renew(newBooleanExpression);
    }

    public void or(T other) {
        Validate.notNull(other);
        BooleanExpression newBooleanExpression = new BooleanExpression((Expression)new BinaryExpression((Expression)this.booleanExpression(), Token.newSymbol((int)162, (int)-1, (int)-1), (Expression)((Assertion)other).booleanExpression()));
        newBooleanExpression.setSourcePosition((ASTNode)this.booleanExpression());
        this.renew(newBooleanExpression);
    }
}

