/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.common.impl.lc;

import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.gcontracts.common.base.BaseLifecycle;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.generation.ClassInvariantGenerator;

public class ClassInvariantLifecycle
extends BaseLifecycle {
    @Override
    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        if (!CandidateChecks.isClassInvariantCandidate(classNode, methodNode)) {
            return;
        }
        if (processingContextInformation.contract().hasDefaultClassInvariant()) {
            return;
        }
        ClassInvariantGenerator classInvariantGenerator = new ClassInvariantGenerator(processingContextInformation.readerSource());
        classInvariantGenerator.addInvariantAssertionStatement(classNode, methodNode);
    }

    @Override
    public void afterProcessingContructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
        if (!CandidateChecks.isClassInvariantCandidate(classNode, constructorNode)) {
            return;
        }
        if (!processingContextInformation.isConstructorAssertionsEnabled()) {
            return;
        }
        if (processingContextInformation.contract().hasDefaultClassInvariant()) {
            return;
        }
        ClassInvariantGenerator classInvariantGenerator = new ClassInvariantGenerator(processingContextInformation.readerSource());
        classInvariantGenerator.addInvariantAssertionStatement(classNode, constructorNode);
    }
}

