/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.classgen.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ContractClosureWriter {
    private int closureCount = 1;

    public ClassNode createClosureClass(ClassNode classNode, MethodNode methodNode, ClosureExpression expression, boolean addOldVariable, boolean addResultVariable, int mods) {
        ClassNode outerClass = this.getOutermostClass(classNode);
        String name = outerClass.getName() + "$" + this.getClosureInnerName(outerClass, classNode);
        ArrayList<Parameter> parametersTemp = new ArrayList<Parameter>(Arrays.asList(expression.getParameters()));
        this.removeParameter("old", parametersTemp);
        this.removeParameter("result", parametersTemp);
        if (methodNode != null && addResultVariable && methodNode.getReturnType() != ClassHelper.VOID_TYPE) {
            parametersTemp.add(new Parameter(methodNode.getReturnType(), "result"));
        }
        if (addOldVariable) {
            parametersTemp.add(new Parameter(new ClassNode(Map.class), "old"));
        }
        ArrayList<Parameter> closureParameters = new ArrayList<Parameter>();
        for (Parameter param : parametersTemp) {
            Parameter closureParameter = new Parameter(param.getType().getPlainNodeReference(), param.getName());
            closureParameters.add(closureParameter);
        }
        ClassNode answer = new ClassNode(name, mods | 0x10, ClassHelper.CLOSURE_TYPE.getPlainNodeReference());
        answer.setSynthetic(true);
        answer.setSourcePosition((ASTNode)expression);
        MethodNode method = answer.addMethod("doCall", 1, ClassHelper.Boolean_TYPE, closureParameters.toArray(new Parameter[closureParameters.size()]), ClassNode.EMPTY_ARRAY, expression.getCode());
        method.setSourcePosition((ASTNode)expression);
        VariableScope varScope = expression.getVariableScope();
        if (varScope == null) {
            throw new RuntimeException("Must have a VariableScope by now! for expression: " + expression + " class: " + name);
        }
        method.setVariableScope(varScope.copy());
        ArgumentListExpression arguments = new ArgumentListExpression();
        for (Parameter parameter : closureParameters) {
            arguments.addExpression((Expression)new VariableExpression((Variable)parameter));
        }
        MethodNode call = answer.addMethod("call", 1, ClassHelper.Boolean_TYPE, closureParameters.toArray(new Parameter[closureParameters.size()]), ClassNode.EMPTY_ARRAY, (Statement)new ReturnStatement((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, "doCall", (Expression)arguments)));
        call.setSourcePosition((ASTNode)expression);
        call.setSynthetic(true);
        BlockStatement block = new BlockStatement();
        VariableExpression outer = new VariableExpression("_outerInstance");
        outer.setSourcePosition((ASTNode)expression);
        block.getVariableScope().putReferencedLocalVariable((Variable)outer);
        VariableExpression thisObject = new VariableExpression("_thisObject");
        thisObject.setSourcePosition((ASTNode)expression);
        block.getVariableScope().putReferencedLocalVariable((Variable)thisObject);
        TupleExpression conArgs = new TupleExpression((Expression)outer, (Expression)thisObject);
        block.addStatement((Statement)new ExpressionStatement((Expression)new ConstructorCallExpression(ClassNode.SUPER, (Expression)conArgs)));
        Parameter[] params = new Parameter[]{new Parameter(ClassHelper.OBJECT_TYPE, "_outerInstance"), new Parameter(ClassHelper.OBJECT_TYPE, "_thisObject")};
        ConstructorNode sn = answer.addConstructor(1, params, ClassNode.EMPTY_ARRAY, (Statement)block);
        sn.setSourcePosition((ASTNode)expression);
        this.correctAccessedVariable(method, expression);
        return answer;
    }

    private void removeParameter(String name, List<Parameter> parameters) {
        Iterator<Parameter> it = parameters.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(name)) continue;
            it.remove();
        }
    }

    private ClassNode getOutermostClass(ClassNode outermostClass) {
        while (outermostClass instanceof InnerClassNode) {
            outermostClass = outermostClass.getOuterClass();
        }
        return outermostClass;
    }

    private void correctAccessedVariable(final MethodNode methodNode, ClosureExpression ce) {
        CodeVisitorSupport visitor = new CodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression expression) {
                Variable v = expression.getAccessedVariable();
                if (v == null) {
                    return;
                }
                String name = expression.getName();
                if (v instanceof DynamicVariable) {
                    for (Parameter param : methodNode.getParameters()) {
                        if (!name.equals(param.getName())) continue;
                        expression.setAccessedVariable((Variable)param);
                    }
                }
            }
        };
        visitor.visitClosureExpression(ce);
    }

    private String getClosureInnerName(ClassNode owner, ClassNode enclosingClass) {
        String ownerShortName = owner.getNameWithoutPackage();
        String classShortName = enclosingClass.getNameWithoutPackage();
        classShortName = classShortName.equals(ownerShortName) ? "" : classShortName + "_";
        int dp = classShortName.lastIndexOf("$");
        if (dp >= 0) {
            classShortName = classShortName.substring(++dp);
        }
        if (classShortName.startsWith("_")) {
            classShortName = classShortName.substring(1);
        }
        return "_gc_" + classShortName + "closure" + this.closureCount++;
    }
}

