/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.syntax.Token;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.generation.BaseGenerator;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.util.AnnotationUtils;

public class DynamicSetterInjectionVisitor
extends BaseVisitor {
    private static final String SPRING_STEREOTYPE_PACKAGE = "org.springframework.stereotype";
    private BlockStatement invariantAssertionBlockStatement;

    public DynamicSetterInjectionVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    protected Statement createSetterBlock(ClassNode classNode, FieldNode field, Parameter parameter) {
        BlockStatement setterMethodBlock = new BlockStatement();
        setterMethodBlock.addStatement((Statement)this.invariantAssertionBlockStatement);
        BinaryExpression fieldAssignment = new BinaryExpression((Expression)new FieldExpression(field), Token.newSymbol((int)100, (int)-1, (int)-1), (Expression)new VariableExpression((Variable)parameter));
        setterMethodBlock.addStatement((Statement)new ExpressionStatement((Expression)fieldAssignment));
        setterMethodBlock.addStatement((Statement)this.invariantAssertionBlockStatement);
        return setterMethodBlock;
    }

    public void visitProperty(PropertyNode node) {
        ClassNode classNode = node.getDeclaringClass();
        String setterName = "set" + MetaClassHelper.capitalize((String)node.getName());
        Statement setterBlock = node.getSetterBlock();
        Parameter parameter = new Parameter(node.getType(), "value");
        if (CandidateChecks.isClassInvariantCandidate(node) && setterBlock == null && classNode.getMethod(setterName, new Parameter[]{parameter}) == null) {
            Statement setterBlockStatement = this.createSetterBlock(classNode, node.getField(), parameter);
            node.setSetterBlock(setterBlockStatement);
        }
    }

    public void visitClass(ClassNode classNode) {
        MethodNode invariantMethodNode = BaseGenerator.getInvariantMethodNode(classNode);
        if (invariantMethodNode == null || AnnotationUtils.hasAnnotationOfType((AnnotatedNode)classNode, SPRING_STEREOTYPE_PACKAGE)) {
            return;
        }
        this.invariantAssertionBlockStatement = new BlockStatement();
        this.invariantAssertionBlockStatement.addStatement((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)VariableExpression.THIS_EXPRESSION, invariantMethodNode.getName(), (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        List declaredConstructors = classNode.getDeclaredConstructors();
        if (declaredConstructors == null || declaredConstructors.isEmpty()) {
            ConstructorNode constructor = new ConstructorNode(1, (Statement)this.invariantAssertionBlockStatement);
            constructor.setSynthetic(true);
            classNode.addConstructor(constructor);
        }
        super.visitClass(classNode);
    }
}

