/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.gcontracts.annotations.meta.ContractElement;
import org.gcontracts.annotations.meta.Postcondition;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.common.spi.AnnotationProcessor;
import org.gcontracts.common.spi.ProcessingContextInformation;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.util.AnnotationUtils;
import org.gcontracts.util.Validate;

public class AnnotationProcessorVisitor
extends BaseVisitor {
    private ProcessingContextInformation pci;

    public AnnotationProcessorVisitor(SourceUnit sourceUnit, ReaderSource source, ProcessingContextInformation pci) {
        super(sourceUnit, source);
        Validate.notNull(pci);
        this.pci = pci;
    }

    public void visitClass(ClassNode type) {
        this.handleClassNode(type);
        ArrayList methodNodes = new ArrayList();
        methodNodes.addAll(type.getMethods());
        methodNodes.addAll(type.getDeclaredConstructors());
        for (MethodNode methodNode : methodNodes) {
            if (!CandidateChecks.isClassInvariantCandidate(type, methodNode) && !CandidateChecks.isPreOrPostconditionCandidate(type, methodNode)) continue;
            this.handleMethodNode(methodNode, AnnotationUtils.hasMetaAnnotations((AnnotatedNode)methodNode, ContractElement.class.getName()));
        }
        this.visitInterfaces(type, type.getInterfaces());
        this.visitAbstractBaseClassesForInterfaceMethodNodes(type, type.getSuperClass());
    }

    private void visitAbstractBaseClassesForInterfaceMethodNodes(ClassNode origin, ClassNode superClass) {
        if (superClass == null) {
            return;
        }
        if (!Modifier.isAbstract(superClass.getModifiers())) {
            return;
        }
        for (ClassNode interfaceClassNode : superClass.getInterfaces()) {
            ArrayList methodNodes = new ArrayList();
            methodNodes.addAll(interfaceClassNode.getMethods());
            for (MethodNode interfaceMethodNode : methodNodes) {
                MethodNode implementationInOriginClassNode;
                MethodNode implementingMethodNode;
                List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceMethodNode, ContractElement.class.getName());
                if (annotationNodes == null || annotationNodes.isEmpty() || (implementingMethodNode = superClass.getMethod(interfaceMethodNode.getName(), interfaceMethodNode.getParameters())) != null || (implementationInOriginClassNode = origin.getMethod(interfaceMethodNode.getName(), interfaceMethodNode.getParameters())) == null) continue;
                this.handleMethodNode(implementationInOriginClassNode, annotationNodes);
            }
        }
    }

    private void visitInterfaces(ClassNode classNode, ClassNode[] interfaces) {
        for (ClassNode interfaceClassNode : interfaces) {
            ArrayList methodNodes = new ArrayList();
            methodNodes.addAll(interfaceClassNode.getMethods());
            for (MethodNode interfaceMethodNode : methodNodes) {
                MethodNode implementingMethodNode = classNode.getMethod(interfaceMethodNode.getName(), interfaceMethodNode.getParameters());
                if (implementingMethodNode == null) continue;
                List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)interfaceMethodNode, ContractElement.class.getName());
                this.handleInterfaceMethodNode(classNode, implementingMethodNode, annotationNodes);
            }
            this.visitInterfaces(classNode, interfaceClassNode.getInterfaces());
        }
    }

    private void handleClassNode(ClassNode classNode) {
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)classNode, ContractElement.class.getName());
        for (AnnotationNode annotationNode : annotationNodes) {
            AnnotationProcessor annotationProcessor = this.createAnnotationProcessor(annotationNode);
            if (annotationProcessor == null || !(annotationNode.getMember("value") instanceof ClassExpression)) continue;
            ClassExpression closureClassExpression = (ClassExpression)annotationNode.getMember("value");
            MethodCallExpression doCall = new MethodCallExpression((Expression)new ConstructorCallExpression(closureClassExpression.getType(), (Expression)new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION)), "doCall", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS);
            doCall.setMethodTarget((MethodNode)closureClassExpression.getType().getMethods("doCall").get(0));
            BooleanExpression booleanExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)annotationNode);
            annotationProcessor.process(this.pci, this.pci.contract(), classNode, (BlockStatement)closureClassExpression.getNodeMetaData((Object)"org.gcontracts.META_DATA.ORIGINAL_TRY_CATCH_BLOCK"), booleanExpression);
        }
    }

    private void handleInterfaceMethodNode(ClassNode type, MethodNode methodNode, List<AnnotationNode> annotationNodes) {
        this.handleMethodNode(type.getMethod(methodNode.getName(), methodNode.getParameters()), annotationNodes);
    }

    private void handleMethodNode(MethodNode methodNode, List<AnnotationNode> annotationNodes) {
        if (methodNode == null) {
            return;
        }
        for (AnnotationNode annotationNode : annotationNodes) {
            VariableExpression variableExpression;
            AnnotationProcessor annotationProcessor = this.createAnnotationProcessor(annotationNode);
            if (annotationProcessor == null || !(annotationNode.getMember("value") instanceof ClassExpression)) continue;
            boolean isPostcondition = AnnotationUtils.hasAnnotationOfType((AnnotatedNode)annotationNode.getClassNode(), Postcondition.class.getName());
            ClassExpression closureClassExpression = (ClassExpression)annotationNode.getMember("value");
            ArgumentListExpression closureArgumentList = new ArgumentListExpression();
            for (Parameter parameter : methodNode.getParameters()) {
                closureArgumentList.addExpression((Expression)new VariableExpression((Variable)parameter));
            }
            if (methodNode.getReturnType() != ClassHelper.VOID_TYPE && isPostcondition && !(methodNode instanceof ConstructorNode)) {
                variableExpression = new VariableExpression("result", methodNode.getReturnType());
                variableExpression.setAccessedVariable((Variable)variableExpression);
                closureArgumentList.addExpression((Expression)variableExpression);
            }
            if (isPostcondition && !(methodNode instanceof ConstructorNode)) {
                variableExpression = new VariableExpression("old", new ClassNode(Map.class));
                variableExpression.setAccessedVariable((Variable)variableExpression);
                closureArgumentList.addExpression((Expression)variableExpression);
            }
            MethodCallExpression doCall = new MethodCallExpression((Expression)new ConstructorCallExpression(annotationNode.getMember("value").getType(), (Expression)new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)VariableExpression.THIS_EXPRESSION)), "doCall", (Expression)closureArgumentList);
            ClassNode type = annotationNode.getMember("value").getType();
            doCall.setMethodTarget((MethodNode)type.getMethods("doCall").get(0));
            BooleanExpression booleanExpression = new BooleanExpression((Expression)doCall);
            booleanExpression.setSourcePosition((ASTNode)annotationNode);
            annotationProcessor.process(this.pci, this.pci.contract(), methodNode.getDeclaringClass(), methodNode, (BlockStatement)closureClassExpression.getNodeMetaData((Object)"org.gcontracts.META_DATA.ORIGINAL_TRY_CATCH_BLOCK"), booleanExpression);
            if (AnnotationUtils.hasAnnotationOfType((AnnotatedNode)methodNode, annotationNode.getClassNode().getName())) continue;
            AnnotationNode annotationMarker = new AnnotationNode(annotationNode.getClassNode());
            annotationMarker.setMember("value", annotationNode.getMember("value"));
            annotationMarker.setRuntimeRetention(true);
            annotationMarker.setSourceRetention(false);
            methodNode.addAnnotation(annotationMarker);
        }
    }

    private AnnotationProcessor createAnnotationProcessor(AnnotationNode annotationNode) {
        ClassExpression annotationProcessingAnno = null;
        List annotations = annotationNode.getClassNode().redirect().getAnnotations();
        for (AnnotationNode anno : annotations) {
            Class typeClass = anno.getClassNode().getTypeClass();
            if (!typeClass.getName().equals("org.gcontracts.annotations.meta.AnnotationProcessorImplementation")) continue;
            annotationProcessingAnno = (ClassExpression)anno.getMember("value");
            break;
        }
        if (annotationProcessingAnno == null) {
            throw new GroovyBugError("Annotation processing class could not be found! This indicates a bug in GContracts, please file an issue!");
        }
        try {
            Class<?> clz = Class.forName(annotationProcessingAnno.getType().getTypeClass().getName());
            return (AnnotationProcessor)clz.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        throw new GroovyBugError("Annotation processing class could not be instantiated! This indicates a bug in GContracts, please file an issue!");
    }
}

