/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;
import org.gcontracts.ClassInvariantViolation;
import org.gcontracts.PostconditionViolation;
import org.gcontracts.PreconditionViolation;
import org.gcontracts.annotations.meta.ContractElement;
import org.gcontracts.annotations.meta.Postcondition;
import org.gcontracts.ast.visitor.ASTNodeMetaData;
import org.gcontracts.ast.visitor.BaseVisitor;
import org.gcontracts.classgen.asm.ContractClosureWriter;
import org.gcontracts.generation.AssertStatementCreationUtility;
import org.gcontracts.generation.CandidateChecks;
import org.gcontracts.generation.TryCatchBlockGenerator;
import org.gcontracts.util.AnnotationUtils;
import org.gcontracts.util.ExpressionUtils;
import org.gcontracts.util.FieldValues;
import org.gcontracts.util.Validate;
import org.objectweb.asm.Opcodes;

public class AnnotationClosureVisitor
extends BaseVisitor
implements ASTNodeMetaData {
    public static final String META_DATA_USE_EXECUTION_TRACKER = "org.gcontracts.META_DATA.USE_EXECUTION_TRACKER";
    public static final String META_DATA_ORIGINAL_TRY_CATCH_BLOCK = "org.gcontracts.META_DATA.ORIGINAL_TRY_CATCH_BLOCK";
    private static final String POSTCONDITION_TYPE_NAME = Postcondition.class.getName();
    private static final ClassNode FIELD_VALUES = ClassHelper.makeCached(FieldValues.class);
    private ClassNode classNode;
    private final ContractClosureWriter contractClosureWriter = new ContractClosureWriter();

    public AnnotationClosureVisitor(SourceUnit sourceUnit, ReaderSource source) {
        super(sourceUnit, source);
    }

    public void visitClass(ClassNode node) {
        if (node == null) {
            return;
        }
        if (!CandidateChecks.isInterfaceContractsCandidate(node) && !CandidateChecks.isContractsCandidate(node)) {
            return;
        }
        this.classNode = node;
        if (this.classNode.getNodeMetaData((Object)"org.gcontracts.CLOSURE_REPLACED") == null && CandidateChecks.isContractsCandidate(node)) {
            List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)node, ContractElement.class.getName());
            for (AnnotationNode annotationNode : annotationNodes) {
                Expression expression = annotationNode.getMember("value");
                if (expression == null || expression instanceof ClassExpression) continue;
                ClosureExpression closureExpression = (ClosureExpression)expression;
                ClosureExpressionValidator validator = new ClosureExpressionValidator(this.classNode, null, annotationNode, this.sourceUnit);
                validator.visitClosureExpression(closureExpression);
                validator.secondPass(closureExpression);
                ArrayList<Parameter> parameters = new ArrayList<Parameter>(Arrays.asList(closureExpression.getParameters()));
                List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
                if (booleanExpressions == null || booleanExpressions.isEmpty()) continue;
                BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
                BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(ClassHelper.makeWithoutCaching(ClassInvariantViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + " \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
                newClosureBlockStatement.setSourcePosition((ASTNode)closureBlockStatement);
                ClosureExpression rewrittenClosureExpression = new ClosureExpression(parameters.toArray(new Parameter[parameters.size()]), (Statement)newClosureBlockStatement);
                rewrittenClosureExpression.setSourcePosition((ASTNode)closureExpression);
                rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
                rewrittenClosureExpression.setSynthetic(true);
                rewrittenClosureExpression.setVariableScope(closureExpression.getVariableScope());
                rewrittenClosureExpression.setType(closureExpression.getType());
                ClassNode closureClassNode = this.contractClosureWriter.createClosureClass(this.classNode, null, rewrittenClosureExpression, false, false, 1);
                this.classNode.getModule().addClass(closureClassNode);
                ClassExpression value = new ClassExpression(closureClassNode);
                value.setSourcePosition((ASTNode)annotationNode);
                BlockStatement value1 = TryCatchBlockGenerator.generateTryCatchBlockForInlineMode(ClassHelper.makeWithoutCaching(ClassInvariantViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + " \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
                value1.setNodeMetaData((Object)META_DATA_USE_EXECUTION_TRACKER, (Object)validator.isMethodCalls());
                value.setNodeMetaData((Object)META_DATA_ORIGINAL_TRY_CATCH_BLOCK, (Object)value1);
                annotationNode.setMember("value", (Expression)value);
                this.markClosureReplaced((ASTNode)this.classNode);
            }
        }
        super.visitClass(node);
        this.visitClass(node.getSuperClass());
        for (ClassNode i : node.getInterfaces()) {
            this.visitClass(i);
        }
        this.markProcessed((ASTNode)this.classNode);
    }

    public void visitConstructorOrMethod(MethodNode methodNode, boolean isConstructor) {
        if (!CandidateChecks.couldBeContractElementMethodNode(this.classNode, methodNode) && !CandidateChecks.isPreconditionCandidate(this.classNode, methodNode)) {
            return;
        }
        if (methodNode.getNodeMetaData((Object)"org.gcontracts.CLOSURE_REPLACED") != null) {
            return;
        }
        List<AnnotationNode> annotationNodes = AnnotationUtils.hasMetaAnnotations((AnnotatedNode)methodNode, ContractElement.class.getName());
        for (AnnotationNode annotationNode : annotationNodes) {
            this.replaceWithClosureClassReference(annotationNode, methodNode);
        }
        this.markProcessed((ASTNode)methodNode);
        super.visitConstructorOrMethod(methodNode, isConstructor);
    }

    private void replaceWithClosureClassReference(AnnotationNode annotationNode, MethodNode methodNode) {
        Validate.notNull(annotationNode);
        Validate.notNull(methodNode);
        boolean isPostcondition = AnnotationUtils.hasAnnotationOfType((AnnotatedNode)annotationNode.getClassNode(), Postcondition.class.getName());
        Expression expression = annotationNode.getMember("value");
        if (expression == null || expression instanceof ClassExpression) {
            return;
        }
        ClosureExpression closureExpression = (ClosureExpression)expression;
        ClosureExpressionValidator validator = new ClosureExpressionValidator(this.classNode, methodNode, annotationNode, this.sourceUnit);
        validator.visitClosureExpression(closureExpression);
        validator.secondPass(closureExpression);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(Arrays.asList(closureExpression.getParameters()));
        parameters.addAll(new ArrayList<Parameter>(Arrays.asList(methodNode.getParameters())));
        List<BooleanExpression> booleanExpressions = ExpressionUtils.getBooleanExpression(closureExpression);
        if (booleanExpressions == null || booleanExpressions.isEmpty()) {
            return;
        }
        BlockStatement closureBlockStatement = (BlockStatement)closureExpression.getCode();
        BlockStatement newClosureBlockStatement = TryCatchBlockGenerator.generateTryCatchBlock(isPostcondition ? ClassHelper.makeWithoutCaching(PostconditionViolation.class) : ClassHelper.makeWithoutCaching(PreconditionViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + "." + methodNode.getTypeDescriptor() + " \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
        newClosureBlockStatement.setSourcePosition((ASTNode)closureBlockStatement);
        ClosureExpression rewrittenClosureExpression = new ClosureExpression(parameters.toArray(new Parameter[parameters.size()]), (Statement)newClosureBlockStatement);
        rewrittenClosureExpression.setSourcePosition((ASTNode)closureExpression);
        rewrittenClosureExpression.setDeclaringClass(closureExpression.getDeclaringClass());
        rewrittenClosureExpression.setSynthetic(true);
        rewrittenClosureExpression.setVariableScope(this.correctVariableScope(closureExpression.getVariableScope(), methodNode));
        rewrittenClosureExpression.setType(closureExpression.getType());
        boolean isConstructor = methodNode instanceof ConstructorNode;
        ClassNode closureClassNode = this.contractClosureWriter.createClosureClass(this.classNode, methodNode, rewrittenClosureExpression, isPostcondition && !isConstructor, isPostcondition && !isConstructor, 1);
        this.classNode.getModule().addClass(closureClassNode);
        ClassExpression value = new ClassExpression(closureClassNode);
        value.setSourcePosition((ASTNode)annotationNode);
        BlockStatement value1 = TryCatchBlockGenerator.generateTryCatchBlockForInlineMode(isPostcondition ? ClassHelper.makeWithoutCaching(PostconditionViolation.class) : ClassHelper.makeWithoutCaching(PreconditionViolation.class), "<" + annotationNode.getClassNode().getName() + "> " + this.classNode.getName() + "." + methodNode.getTypeDescriptor() + " \n\n", (Statement)AssertStatementCreationUtility.getAssertionStatemens(booleanExpressions));
        value1.setNodeMetaData((Object)META_DATA_USE_EXECUTION_TRACKER, (Object)validator.isMethodCalls());
        value.setNodeMetaData((Object)META_DATA_ORIGINAL_TRY_CATCH_BLOCK, (Object)value1);
        annotationNode.setMember("value", (Expression)value);
        this.markClosureReplaced((ASTNode)methodNode);
    }

    private VariableScope correctVariableScope(VariableScope variableScope, MethodNode methodNode) {
        if (variableScope == null) {
            return null;
        }
        if (methodNode == null || methodNode.getParameters() == null || methodNode.getParameters().length == 0) {
            return variableScope;
        }
        VariableScope copy = this.copy(variableScope);
        Iterator iterator = variableScope.getReferencedClassVariablesIterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            String name = variable.getName();
            for (Parameter parameter : methodNode.getParameters()) {
                if (!parameter.getName().equals(name)) continue;
                copy.putReferencedLocalVariable((Variable)parameter);
                break;
            }
            if (copy.isReferencedLocalVariable(name)) continue;
            copy.putReferencedClassVariable(variable);
        }
        return copy;
    }

    private VariableScope copy(VariableScope original) {
        VariableScope copy = new VariableScope(original.getParent());
        copy.setClassScope(original.getClassScope());
        copy.setInStaticContext(original.isInStaticContext());
        return copy;
    }

    private void markProcessed(ASTNode someNode) {
        if (someNode.getNodeMetaData((Object)"org.gcontracts.CLOSURE_REPLACED") == null) {
            someNode.setNodeMetaData((Object)"org.gcontracts.CLOSURE_REPLACED", (Object)Boolean.TRUE);
        }
    }

    private void markClosureReplaced(ASTNode someNode) {
        if (someNode.getNodeMetaData((Object)"org.gcontracts.CLOSURE_REPLACED") == null) {
            someNode.setNodeMetaData((Object)"org.gcontracts.CLOSURE_REPLACED", (Object)Boolean.TRUE);
        }
    }

    static class ClosureExpressionValidator
    extends ClassCodeVisitorSupport
    implements Opcodes {
        private final ClassNode classNode;
        private final MethodNode methodNode;
        private final AnnotationNode annotationNode;
        private final SourceUnit sourceUnit;
        private final Map<VariableExpression, StaticMethodCallExpression> variableExpressions;
        private boolean secondPass = false;
        private boolean methodCalls = false;

        public ClosureExpressionValidator(ClassNode classNode, MethodNode methodNode, AnnotationNode annotationNode, SourceUnit sourceUnit) {
            this.classNode = classNode;
            this.methodNode = methodNode;
            this.annotationNode = annotationNode;
            this.sourceUnit = sourceUnit;
            this.variableExpressions = new HashMap<VariableExpression, StaticMethodCallExpression>();
        }

        public void visitClosureExpression(ClosureExpression expression) {
            this.secondPass = false;
            if (expression.getCode() == null || expression.getCode() instanceof EmptyStatement) {
                this.addError("[GContracts] Annotation does not contain any expressions (e.g. use '@Requires({ argument1 })').", (ASTNode)expression);
            }
            if (expression.getCode() instanceof BlockStatement && ((BlockStatement)expression.getCode()).getStatements().isEmpty()) {
                this.addError("[GContracts] Annotation does not contain any expressions (e.g. use '@Requires({ argument1 })').", (ASTNode)expression);
            }
            if (expression.isParameterSpecified() && !AnnotationUtils.hasAnnotationOfType((AnnotatedNode)this.annotationNode.getClassNode(), POSTCONDITION_TYPE_NAME)) {
                this.addError("[GContracts] Annotation does not support parameters (the only exception are postconditions).", (ASTNode)expression);
            }
            if (expression.isParameterSpecified()) {
                for (Parameter param : expression.getParameters()) {
                    if (!"result".equals(param.getName()) && !"old".equals(param.getName())) {
                        this.addError("[GContracts] Postconditions only allow 'old' and 'result' closure parameters.", (ASTNode)expression);
                    }
                    if (param.isDynamicTyped()) continue;
                    this.addError("[GContracts] Postconditions do not support explicit types.", (ASTNode)expression);
                }
            }
            super.visitClosureExpression(expression);
        }

        public void visitVariableExpression(VariableExpression expression) {
            Parameter parameter;
            FieldNode fieldNode;
            Variable accessedVariable = this.getParameterCandidate(expression.getAccessedVariable());
            if (accessedVariable instanceof FieldNode && ((fieldNode = (FieldNode)accessedVariable).getModifiers() & 2) != 0 && !this.classNode.hasProperty(fieldNode.getName())) {
                StaticMethodCallExpression staticMethodCallExpression = new StaticMethodCallExpression(FIELD_VALUES, "fieldValue", (Expression)new ArgumentListExpression((Expression)VariableExpression.THIS_EXPRESSION, (Expression)new ConstantExpression((Object)fieldNode.getName()), (Expression)new ClassExpression(fieldNode.getType())));
                this.variableExpressions.put(expression, staticMethodCallExpression);
            }
            if (accessedVariable instanceof Parameter && "it".equals((parameter = (Parameter)accessedVariable).getName())) {
                this.addError("[GContracts] Access to 'it' is not supported.", (ASTNode)expression);
            }
            expression.setAccessedVariable(accessedVariable);
            super.visitVariableExpression(expression);
        }

        public void visitPostfixExpression(PostfixExpression expression) {
            VariableExpression variableExpression;
            this.checkOperation((Expression)expression, expression.getOperation());
            if (this.secondPass && expression.getExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getExpression())) {
                expression.setExpression((Expression)this.variableExpressions.get(variableExpression));
            }
            super.visitPostfixExpression(expression);
        }

        public void visitPrefixExpression(PrefixExpression expression) {
            VariableExpression variableExpression;
            this.checkOperation((Expression)expression, expression.getOperation());
            if (this.secondPass && expression.getExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getExpression())) {
                expression.setExpression((Expression)this.variableExpressions.get(variableExpression));
            }
            super.visitPrefixExpression(expression);
        }

        public void visitBinaryExpression(BinaryExpression expression) {
            this.checkOperation((Expression)expression, expression.getOperation());
            if (this.secondPass) {
                VariableExpression variableExpression;
                if (expression.getLeftExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getLeftExpression())) {
                    expression.setLeftExpression((Expression)this.variableExpressions.get(variableExpression));
                }
                if (expression.getRightExpression() instanceof VariableExpression && this.variableExpressions.containsKey(variableExpression = (VariableExpression)expression.getRightExpression())) {
                    expression.setRightExpression((Expression)this.variableExpressions.get(variableExpression));
                }
            }
            super.visitBinaryExpression(expression);
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
            this.methodCalls = true;
            super.visitStaticMethodCallExpression(call);
        }

        public void visitMethodCallExpression(MethodCallExpression call) {
            this.methodCalls = true;
            super.visitMethodCallExpression(call);
        }

        public void visitConstructorCallExpression(ConstructorCallExpression call) {
            this.methodCalls = true;
            super.visitConstructorCallExpression(call);
        }

        private void checkOperation(Expression expression, Token operation) {
            if (Types.ofType((int)operation.getType(), (int)1100)) {
                this.addError("[GContracts] Assignment operators are not supported.", (ASTNode)expression);
            }
            if (Types.ofType((int)operation.getType(), (int)1210)) {
                this.addError("[GContracts] State changing postfix & prefix operators are not supported.", (ASTNode)expression);
            }
        }

        private Variable getParameterCandidate(Variable variable) {
            if (variable == null || this.methodNode == null) {
                return variable;
            }
            if (variable instanceof Parameter) {
                return variable;
            }
            String name = variable.getName();
            for (Parameter param : this.methodNode.getParameters()) {
                if (!name.equals(param.getName())) continue;
                return param;
            }
            return variable;
        }

        public void secondPass(ClosureExpression closureExpression) {
            this.secondPass = true;
            super.visitClosureExpression(closureExpression);
        }

        public boolean isMethodCalls() {
            return this.methodCalls;
        }

        protected SourceUnit getSourceUnit() {
            return this.sourceUnit;
        }
    }
}

