/*
 * Decompiled with CFR 0.152.
 */
package org.gcontracts.ast;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.gcontracts.annotations.Contracted;
import org.gcontracts.ast.BaseASTTransformation;
import org.gcontracts.ast.visitor.AnnotationProcessorVisitor;
import org.gcontracts.ast.visitor.DomainModelInjectionVisitor;
import org.gcontracts.ast.visitor.DynamicSetterInjectionVisitor;
import org.gcontracts.ast.visitor.LifecycleAfterTransformationVisitor;
import org.gcontracts.ast.visitor.LifecycleBeforeTransformationVisitor;
import org.gcontracts.common.spi.ProcessingContextInformation;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class GContractsASTTransformation
extends BaseASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit unit) {
        ModuleNode moduleNode = unit.getAST();
        ReaderSource source = this.getReaderSource(unit);
        ClassNode contractedAnnotationClassNode = ClassHelper.makeWithoutCaching(Contracted.class);
        for (ClassNode classNode : moduleNode.getClasses()) {
            if (classNode.getAnnotations(contractedAnnotationClassNode).isEmpty()) continue;
            ProcessingContextInformation pci = new ProcessingContextInformation(classNode, unit, source);
            new LifecycleBeforeTransformationVisitor(unit, source, pci).visitClass(classNode);
            new AnnotationProcessorVisitor(unit, source, pci).visitClass(classNode);
            new DomainModelInjectionVisitor(unit, source, pci).visitClass(classNode);
            new LifecycleAfterTransformationVisitor(unit, source, pci).visitClass(classNode);
            new DynamicSetterInjectionVisitor(unit, source).visitClass(classNode);
        }
    }
}

