/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;

public final class SuppressModernizerAnnotationDetector {
    private final Set<String> annotatedClassNames = new HashSet<String>();
    private final Set<String> allClassNames = new HashSet<String>();

    private SuppressModernizerAnnotationDetector() {
    }

    public static Set<String> detect(Path path) throws IOException {
        SuppressModernizerAnnotationDetector detector = new SuppressModernizerAnnotationDetector();
        detector.detectInternal(path);
        return detector.computeSuppressedClassNames();
    }

    static Set<String> detect(Class<?> ... classes) throws IOException {
        SuppressModernizerAnnotationDetector detector = new SuppressModernizerAnnotationDetector();
        for (Class<?> clazz : classes) {
            ClassReader classReader = new ClassReader(clazz.getName());
            detector.detectInternal(classReader);
        }
        return detector.computeSuppressedClassNames();
    }

    private Set<String> computeSuppressedClassNames() {
        HashSet<String> suppressedClassNames = new HashSet<String>(this.annotatedClassNames);
        block0: for (String className : this.allClassNames) {
            int index;
            if (suppressedClassNames.contains(className)) continue;
            int fromIndex = 0;
            while ((index = className.indexOf(36, fromIndex)) != -1) {
                boolean outerSuppressed = this.annotatedClassNames.contains(className.substring(0, index));
                if (outerSuppressed) {
                    suppressedClassNames.add(className);
                    continue block0;
                }
                fromIndex = index + 1;
            }
        }
        return suppressedClassNames;
    }

    private void detectInternal(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream<Path> stream = Files.list(path);
            Iterable children = stream::iterator;
            for (Path child : children) {
                this.detectInternal(path.resolve(child));
            }
        } else if (path.toString().endsWith(".class")) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                this.detectInternal(new ClassReader(inputStream));
            }
        }
    }

    private void detectInternal(ClassReader classReader) {
        classReader.accept((ClassVisitor)new Visitor(), 0);
    }

    private final class Visitor
    extends ClassVisitor {
        private String className;

        Visitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            SuppressModernizerAnnotationDetector.this.allClassNames.add(this.className);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            boolean isSuppressModernizer = Type.getType((String)desc).getClassName().equals(SuppressModernizer.class.getName());
            if (isSuppressModernizer) {
                SuppressModernizerAnnotationDetector.this.annotatedClassNames.add(this.className);
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MethodVisitor methodvisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
            return new SimpleMethodVisitor(589824, methodvisitor, this.className);
        }
    }

    private final class SimpleMethodVisitor
    extends MethodVisitor {
        private final String className;

        SimpleMethodVisitor(int api, MethodVisitor methodVisitor, String className) {
            super(api, methodVisitor);
            this.className = className;
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
            boolean isSuppressModernizer = Type.getType((String)descriptor).getClassName().equals(SuppressModernizer.class.getName());
            if (isSuppressModernizer) {
                SuppressModernizerAnnotationDetector.this.annotatedClassNames.add(this.className);
            }
            return super.visitLocalVariableAnnotation(typeRef, typePath, start, end, index, descriptor, visible);
        }
    }
}

