/*
 * Decompiled with CFR 0.152.
 */
package org.gaul.modernizer_maven_plugin;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public final class SuppressGeneratedAnnotationDetector {
    private final Set<String> annotatedClassNames = new HashSet<String>();
    private final Set<String> allClassNames = new HashSet<String>();

    private SuppressGeneratedAnnotationDetector() {
    }

    public static Set<String> detect(Path path) throws IOException {
        SuppressGeneratedAnnotationDetector detector = new SuppressGeneratedAnnotationDetector();
        detector.detectInternal(path);
        return detector.computeSuppressedClassNames();
    }

    private Set<String> computeSuppressedClassNames() {
        HashSet<String> suppressedClassNames = new HashSet<String>(this.annotatedClassNames);
        block0: for (String className : this.allClassNames) {
            int index;
            if (suppressedClassNames.contains(className)) continue;
            int fromIndex = 0;
            while ((index = className.indexOf(36, fromIndex)) != -1) {
                boolean outerSuppressed = this.annotatedClassNames.contains(className.substring(0, index));
                if (outerSuppressed) {
                    suppressedClassNames.add(className);
                    continue block0;
                }
                fromIndex = index + 1;
            }
        }
        return suppressedClassNames;
    }

    private void detectInternal(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            Stream<Path> stream = Files.list(path);
            Iterable children = stream::iterator;
            for (Path child : children) {
                this.detectInternal(path.resolve(child));
            }
        } else if (path.toString().endsWith(".class")) {
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                this.detectInternal(new ClassReader(inputStream));
            }
        }
    }

    private void detectInternal(ClassReader classReader) {
        classReader.accept((ClassVisitor)new Visitor(), 0);
    }

    private final class Visitor
    extends ClassVisitor {
        private String className;

        Visitor() {
            super(589824);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            SuppressGeneratedAnnotationDetector.this.allClassNames.add(this.className);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            String name = desc.substring(Math.max(desc.lastIndexOf(47), desc.lastIndexOf(36)) + 1);
            boolean isGenerated = name.contains("Generated");
            if (isGenerated) {
                SuppressGeneratedAnnotationDetector.this.annotatedClassNames.add(this.className);
            }
            return super.visitAnnotation(desc, visible);
        }
    }
}

