/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.gagravarr.vorbis.VorbisAudioData;
import org.gagravarr.vorbis.VorbisFile;
import org.gagravarr.vorbis.VorbisStyleComments;
import org.gagravarr.vorbis.tools.VorbisLikeCommentTool;

public class VorbisCommentTool
extends VorbisLikeCommentTool {
    public static void main(String[] args) throws Exception {
        VorbisLikeCommentTool.Command command = VorbisCommentTool.processArgs(args, "VorbisComment");
        VorbisFile vf = new VorbisFile(new File(command.inFile));
        if (command.command == VorbisLikeCommentTool.Command.Commands.List) {
            VorbisCommentTool.listTags((VorbisStyleComments)vf.getComment());
        } else {
            VorbisAudioData ad;
            VorbisCommentTool.addTags((VorbisStyleComments)vf.getComment(), command);
            ArrayList<VorbisAudioData> audio = new ArrayList<VorbisAudioData>();
            while ((ad = vf.getNextAudioPacket()) != null) {
                audio.add(ad);
            }
            vf.close();
            VorbisFile out = new VorbisFile((OutputStream)new FileOutputStream(command.outFile), vf.getSid(), vf.getInfo(), vf.getComment(), vf.getSetup());
            for (VorbisAudioData vad : audio) {
                out.writeAudioData(vad);
            }
            out.close();
        }
    }
}

