/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.vorbis.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gagravarr.vorbis.VorbisStyleComments;

public abstract class VorbisLikeCommentTool {
    public static Command processArgs(String[] args, String programName) throws Exception {
        if (args.length == 0) {
            VorbisLikeCommentTool.printHelp(programName);
            return null;
        }
        if (args.length == 1) {
            return new Command(args[0], null, null, Command.Commands.List);
        }
        if (args.length == 2 && args[0].equals("-l")) {
            return new Command(args[1], null, null, Command.Commands.List);
        }
        if (args[0].equals("-w")) {
            return VorbisLikeCommentTool.processTags(args, Command.Commands.Overwrite);
        }
        if (args[0].equals("-a")) {
            return VorbisLikeCommentTool.processTags(args, Command.Commands.Append);
        }
        VorbisLikeCommentTool.printHelp(programName);
        return null;
    }

    public static void printHelp(String programName) {
        System.err.println("Use:");
        System.err.println("  " + programName + " [-l] file.ogg");
        System.err.println("  " + programName + " -a [-t name=value] [-t name=value] in.ogg [out.ogg]");
        System.err.println("  " + programName + " -w [-t name=value] [-t name=value] in.ogg [out.ogg]");
        System.exit(1);
    }

    public static void listTags(VorbisStyleComments vorbisComments) throws Exception {
        Map comments = vorbisComments.getAllComments();
        for (String tag : comments.keySet()) {
            for (String value : (List)comments.get(tag)) {
                System.out.println(tag + "=" + value);
            }
        }
    }

    public static Command processTags(String[] args, Command.Commands type) {
        String outFile;
        String inFile = outFile = args[args.length - 1];
        if (args.length % 2 == 1) {
            inFile = args[args.length - 2];
        }
        System.out.println("Source file: " + inFile);
        System.out.println("Output file: " + outFile);
        ArrayList<String> tags = new ArrayList<String>();
        for (int i = 1; i < args.length - 2; i += 2) {
            if (!"-t".equals(args[i]) || !args[i + 1].contains("=")) {
                throw new IllegalArgumentException("Expecting '-t name=value' but found '" + args[i] + " " + args[i + 1] + "'");
            }
            tags.add(args[i + 1]);
        }
        return new Command(inFile, outFile, tags, type);
    }

    public static void addTags(VorbisStyleComments vorbisComments, Command command) {
        if (command.command == Command.Commands.Overwrite) {
            vorbisComments.removeAllComments();
        }
        for (String tagPair : command.tagPairs) {
            int split = tagPair.indexOf(61);
            String name = tagPair.substring(0, split);
            String value = tagPair.substring(split + 1);
            System.out.println("   Setting '" + name + " = " + value + "'");
            vorbisComments.addComment(name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Command {
        public final String inFile;
        public final String outFile;
        public final List<String> tagPairs;
        public final Commands command;

        protected Command(String inFile, String outFile, List<String> tagPairs, Commands command) {
            this.inFile = inFile;
            this.outFile = outFile;
            this.tagPairs = tagPairs;
            this.command = command;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Commands {
            List,
            Append,
            Overwrite,
            Help;

        }
    }
}

