/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.util.ArrayList;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.IndexRange;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;
import javafx.scene.text.HitInfo;
import javafx.scene.text.TextFlow;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.TextFlowLayout;
import org.fxmisc.richtext.TextFlowSpan;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;

class TextFlowExt
extends TextFlow {
    private TextFlowLayout layout;

    TextFlowExt() {
    }

    private TextFlowLayout textLayout() {
        if (this.layout == null) {
            this.layout = new TextFlowLayout(this);
        }
        return this.layout;
    }

    int getLineCount() {
        return this.textLayout().getLineCount();
    }

    int getLineStartPosition(int charIdx) {
        TwoLevelNavigator navigator = this.textLayout().getTwoLevelNavigator();
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
        return navigator.position(currentLineIndex, 0).toOffset();
    }

    int getLineEndPosition(int charIdx) {
        TwoLevelNavigator navigator = this.textLayout().getTwoLevelNavigator();
        int currentLineIndex = navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor() + 1;
        int minor = currentLineIndex == this.getLineCount() ? 0 : -1;
        return navigator.position(currentLineIndex, minor).toOffset();
    }

    int getLineOfCharacter(int charIdx) {
        TwoLevelNavigator navigator = this.textLayout().getTwoLevelNavigator();
        return navigator.offsetToPosition(charIdx, TwoDimensional.Bias.Forward).getMajor();
    }

    PathElement[] getCaretShape(int charIdx, boolean isLeading) {
        return this.caretShape(charIdx, isLeading);
    }

    PathElement[] getRangeShape(IndexRange range) {
        return this.getRangeShape(range.getStart(), range.getEnd());
    }

    PathElement[] getRangeShape(int from, int to) {
        return this.rangeShape(from, to);
    }

    PathElement[] getUnderlineShape(IndexRange range) {
        return this.getUnderlineShape(range.getStart(), range.getEnd());
    }

    PathElement[] getUnderlineShape(int from, int to) {
        ArrayList<Object> result = new ArrayList<Object>();
        PathElement[] shape = this.rangeShape(from, to);
        for (int ele = 2; ele < shape.length; ele += 5) {
            LineTo bl = (LineTo)shape[ele + 1];
            LineTo br = (LineTo)shape[ele];
            double y = br.getY() - 2.5;
            result.add(new MoveTo(bl.getX(), y));
            result.add(new LineTo(br.getX(), y));
        }
        return result.toArray(new PathElement[0]);
    }

    CharacterHit hitLine(double x, int lineIndex) {
        return this.hit(x, this.textLayout().getLineCenter(lineIndex));
    }

    CharacterHit hit(double x, double y) {
        TextFlowSpan span = this.textLayout().getLineSpan((float)y);
        Rectangle2D lineBounds = span.getBounds();
        HitInfo hit = this.hitTest(new Point2D(x, y));
        int charIdx = hit.getCharIndex();
        boolean leading = hit.isLeading();
        if (y >= span.getBounds().getMaxY()) {
            return CharacterHit.insertionAt(charIdx);
        }
        if (!leading && this.getLineCount() > 1) {
            boolean bl = leading = this.getLineOfCharacter(charIdx) + 1 < this.getLineCount() && charIdx + 1 >= span.getStart() + span.getLength();
        }
        if (x < lineBounds.getMinX() || x > lineBounds.getMaxX()) {
            if (leading) {
                return CharacterHit.insertionAt(charIdx);
            }
            return CharacterHit.insertionAt(charIdx + 1);
        }
        if (leading) {
            return CharacterHit.leadingHalfOf(charIdx);
        }
        return CharacterHit.trailingHalfOf(charIdx);
    }
}

