/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.TaskWrapper;

public class Message {
    private UTF8Buffer topic;
    private Buffer payload;
    private Runnable onComplete;
    private DispatchQueue queue;

    public Message(DispatchQueue queue, UTF8Buffer topic, Buffer payload, Runnable onComplete) {
        this.queue = queue;
        this.payload = payload;
        this.topic = topic;
        this.onComplete = onComplete;
    }

    public byte[] getPayload() {
        return this.payload.toByteArray();
    }

    public Buffer getPayloadBuffer() {
        return this.payload;
    }

    public String getTopic() {
        return this.topic.toString();
    }

    public UTF8Buffer getTopicBuffer() {
        return this.topic;
    }

    public void ack() {
        if (this.onComplete != null) {
            this.queue.execute(new TaskWrapper(this.onComplete));
            this.onComplete = null;
        }
    }
}

