/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.jmx;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import net.sf.retrotranslator.runtime.java.lang.management.ManagementFactory_;
import org.fusesource.hawtdispatch.Dispatcher;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;

public class JmxService {
    private static CompositeType METRICS_COMPOSITE_TYPE;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$Metrics;

    public static ObjectName objectName(HawtDispatcher dispatcher) {
        try {
            return new ObjectName("org.hawtdispatch:type=Dispatcher,name=" + ObjectName.quote(dispatcher.getLabel()));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static void register(HawtDispatcher dispatcher) throws Exception {
        MBeanServer server = ManagementFactory_.getPlatformMBeanServer();
        server.registerMBean(new JmxDispatcher(dispatcher), JmxService.objectName(dispatcher));
    }

    static {
        CompositeTypeFactory factory = new CompositeTypeFactory();
        factory.addItem("label", "The queue label", SimpleType.STRING);
        factory.addItem("duration", "The length of time spent gathering metricsN", SimpleType.DOUBLE);
        factory.addItem("enqueued", "The number of tasks enqueued", SimpleType.LONG);
        factory.addItem("enqueueTimeMean", "The mean amount of time an enqueued tasks waited before it was executed", SimpleType.DOUBLE);
        factory.addItem("enqueueTimeMax", "The maximum amount of time a single enqueued task waited before it was executed", SimpleType.DOUBLE);
        factory.addItem("enqueueTimeTotal", "The total amount of time all enqueued tasks spent waiting to be executed", SimpleType.DOUBLE);
        factory.addItem("executed", "The number of tasks executed", SimpleType.LONG);
        factory.addItem("executeTimeMean", "The mean amount of time tasks took to execute", SimpleType.DOUBLE);
        factory.addItem("executeTimeMax", "The maximum amount of time a single task took to execute", SimpleType.DOUBLE);
        factory.addItem("executeTimeTotal", "The total amount of time all tasks spent executing", SimpleType.DOUBLE);
        Class<?> clazz = class$org$fusesource$hawtdispatch$Metrics;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$Metrics = new Metrics[0].getClass().getComponentType();
        }
        METRICS_COMPOSITE_TYPE = factory.create(clazz);
    }

    static class CompositeTypeFactory {
        private final List<String> itemNamesList = new ArrayList<String>();
        private final List<String> itemDescriptionsList = new ArrayList<String>();
        private final List<OpenType> itemTypesList = new ArrayList<OpenType>();

        CompositeTypeFactory() {
        }

        protected void addItem(String name, String description, OpenType type) {
            this.itemNamesList.add(name);
            this.itemDescriptionsList.add(description);
            this.itemTypesList.add(type);
        }

        protected CompositeType create(Class clazz) {
            return this.create(clazz.getName(), clazz.getName());
        }

        protected CompositeType create(String name, String description) {
            try {
                String[] itemNames = this.itemNamesList.toArray(new String[this.itemNamesList.size()]);
                String[] itemDescriptions = this.itemDescriptionsList.toArray(new String[this.itemDescriptionsList.size()]);
                OpenType[] itemTypes = this.itemTypesList.toArray(new OpenType[this.itemTypesList.size()]);
                return new CompositeType(name, description, itemNames, itemDescriptions, itemTypes);
            }
            catch (OpenDataException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class JmxDispatcher {
        final Dispatcher dispatcher;
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public JmxDispatcher(Dispatcher dispatcher) {
            this.dispatcher = dispatcher;
        }
    }
}

