/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;

public class FutureTask
implements RunnableFuture {
    private final Callable callable;
    private Object result;
    private Throwable exception;
    private int state;
    private volatile Thread runner;

    public FutureTask(Callable callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        this.callable = callable;
    }

    public FutureTask(Runnable runnable, Object result) {
        this(Executors.callable(runnable, result));
    }

    public synchronized boolean isCancelled() {
        return this.state == 4;
    }

    public synchronized boolean isDone() {
        return this.ranOrCancelled() && this.runner == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            Thread r;
            if (this.ranOrCancelled()) {
                return false;
            }
            this.state = 4;
            if (mayInterruptIfRunning && (r = this.runner) != null) {
                r.interrupt();
            }
            this.runner = null;
            this.notifyAll();
        }
        this.done();
        return true;
    }

    public synchronized Object get() throws InterruptedException, ExecutionException {
        this.waitFor();
        return this.getResult();
    }

    public synchronized Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitFor(unit.toNanos(timeout));
        return this.getResult();
    }

    protected void done() {
    }

    protected void set(Object v) {
        this.setCompleted(v);
    }

    protected void setException(Throwable t) {
        this.setFailed(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            this.runner = Thread.currentThread();
        }
        try {
            this.set(this.callable.call());
        }
        catch (Throwable ex) {
            this.setException(ex);
        }
    }

    private boolean ranOrCancelled() {
        return (this.state & 6) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCompleted(Object result) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.result = result;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFailed(Throwable exception) {
        FutureTask futureTask = this;
        synchronized (futureTask) {
            if (this.ranOrCancelled()) {
                return;
            }
            this.state = 2;
            this.exception = exception;
            this.runner = null;
            this.notifyAll();
        }
        this.done();
    }

    private void waitFor() throws InterruptedException {
        while (!this.isDone()) {
            this.wait();
        }
    }

    private void waitFor(long nanos) throws InterruptedException, TimeoutException {
        if (nanos < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.isDone()) {
            return;
        }
        long deadline = Utils.nanoTime() + nanos;
        while (nanos > 0L) {
            TimeUnit.NANOSECONDS.timedWait(this, nanos);
            if (this.isDone()) {
                return;
            }
            nanos = deadline - Utils.nanoTime();
        }
        throw new TimeoutException();
    }

    private Object getResult() throws ExecutionException {
        if (this.state == 4) {
            throw new CancellationException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }
}

