/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MessageSupport;

public class CONNECT
implements MessageSupport.Message {
    private static final Buffer PROTOCOL_NAME;
    private short keepAlive = (short)30;
    private UTF8Buffer clientId;
    private UTF8Buffer willTopic;
    private UTF8Buffer willMessage = new UTF8Buffer("");
    private boolean willRetain;
    private byte willQos;
    private boolean cleanSession = true;
    private UTF8Buffer userName;
    private UTF8Buffer password;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$mqtt$codec$CONNECT;

    public CONNECT() {
    }

    public CONNECT(CONNECT other) {
        this.keepAlive = other.keepAlive;
        this.clientId = other.clientId;
        this.willTopic = other.willTopic;
        this.willMessage = other.willMessage;
        this.willRetain = other.willRetain;
        this.willQos = other.willQos;
        this.cleanSession = other.cleanSession;
        this.userName = other.userName;
        this.password = other.password;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream(500);
            MessageSupport.writeUTF(os, PROTOCOL_NAME);
            os.writeByte(3);
            int flags = 0;
            if (this.userName != null) {
                flags |= 0x80;
            }
            if (this.password != null) {
                flags |= 0x40;
            }
            if (this.willTopic != null && this.willMessage != null) {
                flags |= 4;
                if (this.willRetain) {
                    flags |= 0x20;
                }
                flags |= this.willQos << 3 & 0x18;
            }
            if (this.cleanSession) {
                flags |= 2;
            }
            os.writeByte(flags);
            os.writeShort(this.keepAlive);
            MessageSupport.writeUTF(os, this.clientId);
            if (this.willTopic != null && this.willMessage != null) {
                MessageSupport.writeUTF(os, this.willTopic);
                MessageSupport.writeUTF(os, this.willMessage);
            }
            if (this.userName != null) {
                MessageSupport.writeUTF(os, this.userName);
            }
            if (this.password != null) {
                MessageSupport.writeUTF(os, this.password);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.commandType(1);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public boolean cleanSession() {
        return this.cleanSession;
    }

    public CONNECT cleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
        return this;
    }

    public UTF8Buffer clientId() {
        return this.clientId;
    }

    public CONNECT clientId(UTF8Buffer clientId) {
        this.clientId = clientId;
        return this;
    }

    public short keepAlive() {
        return this.keepAlive;
    }

    public CONNECT keepAlive(short keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public CONNECT password(UTF8Buffer password) {
        this.password = password;
        return this;
    }

    public CONNECT userName(UTF8Buffer userName) {
        this.userName = userName;
        return this;
    }

    public CONNECT willMessage(UTF8Buffer willMessage) {
        this.willMessage = willMessage;
        return this;
    }

    public CONNECT willQos(QoS willQos) {
        this.willQos = (byte)willQos.ordinal();
        return this;
    }

    public CONNECT willRetain(boolean willRetain) {
        this.willRetain = willRetain;
        return this;
    }

    public CONNECT willTopic(UTF8Buffer willTopic) {
        this.willTopic = willTopic;
        return this;
    }

    public String toString() {
        return "CONNECT{cleanSession=" + this.cleanSession + ", keepAlive=" + this.keepAlive + ", clientId=" + this.clientId + ", willTopic=" + this.willTopic + ", willMessage=" + this.willMessage + ", willRetain=" + this.willRetain + ", willQos=" + this.willQos + ", userName=" + this.userName + ", password=" + this.password + '}';
    }

    static {
        Class<?> clazz = class$org$fusesource$mqtt$codec$CONNECT;
        if (clazz == null) {
            clazz = class$org$fusesource$mqtt$codec$CONNECT = new CONNECT[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        PROTOCOL_NAME = new AsciiBuffer("MQIsdp").buffer();
    }
}

