/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedList;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtdispatch.transport.ProtocolCodec;
import org.fusesource.hawtdispatch.transport.SslTransport;
import org.fusesource.hawtdispatch.transport.TcpTransport;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportAware;
import org.fusesource.hawtdispatch.transport.UdpTransport;
import org.fusesource.hawtdispatch.util.BufferPool;
import org.fusesource.hawtdispatch.util.BufferPools;

public abstract class AbstractProtocolCodec
implements ProtocolCodec,
TransportAware {
    protected BufferPools bufferPools;
    protected BufferPool writeBufferPool;
    protected BufferPool readBufferPool;
    protected int writeBufferSize = 65536;
    protected long writeCounter = 0L;
    protected GatheringByteChannel writeChannel = null;
    protected DataByteArrayOutputStream nextWriteBuffer;
    protected long lastWriteIoSize = 0L;
    protected LinkedList<ByteBuffer> writeBuffer = new LinkedList();
    private long writeBufferRemaining = 0L;
    protected long readCounter = 0L;
    protected int readBufferSize = 65536;
    protected ReadableByteChannel readChannel = null;
    protected ByteBuffer readBuffer;
    protected ByteBuffer directReadBuffer = null;
    protected int readEnd;
    protected int readStart;
    protected int lastReadIoSize;
    protected Action nextDecodeAction;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$AbstractProtocolCodec;

    public void setTransport(Transport transport) {
        if (transport instanceof TcpTransport) {
            TcpTransport tcp = (TcpTransport)transport;
            this.writeBufferSize = tcp.getSendBufferSize();
            this.readBufferSize = tcp.getReceiveBufferSize();
        } else if (transport instanceof UdpTransport) {
            UdpTransport tcp = (UdpTransport)transport;
            this.writeBufferSize = tcp.getSendBufferSize();
            this.readBufferSize = tcp.getReceiveBufferSize();
        } else {
            try {
                if (this.writeChannel instanceof SocketChannel) {
                    this.writeBufferSize = ((SocketChannel)this.writeChannel).socket().getSendBufferSize();
                    this.readBufferSize = ((SocketChannel)this.readChannel).socket().getReceiveBufferSize();
                } else if (this.writeChannel instanceof SslTransport.SSLChannel) {
                    this.writeBufferSize = ((SslTransport.SSLChannel)this.readChannel).socket().getSendBufferSize();
                    this.readBufferSize = ((SslTransport.SSLChannel)this.writeChannel).socket().getReceiveBufferSize();
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        if (this.bufferPools != null) {
            this.readBufferPool = this.bufferPools.getBufferPool(this.readBufferSize);
            this.writeBufferPool = this.bufferPools.getBufferPool(this.writeBufferSize);
        }
    }

    public void setWritableByteChannel(WritableByteChannel channel) throws SocketException {
        this.writeChannel = (GatheringByteChannel)channel;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public boolean full() {
        return this.writeBufferRemaining >= (long)this.writeBufferSize;
    }

    public boolean isEmpty() {
        return this.writeBufferRemaining == 0L && (this.nextWriteBuffer == null || this.nextWriteBuffer.size() == 0);
    }

    public long getWriteCounter() {
        return this.writeCounter;
    }

    protected abstract void encode(Object var1) throws IOException;

    public ProtocolCodec.BufferState write(Object value) throws IOException {
        if (this.full()) {
            return ProtocolCodec.BufferState.FULL;
        }
        boolean wasEmpty = this.isEmpty();
        if (this.nextWriteBuffer == null) {
            this.nextWriteBuffer = this.allocateNextWriteBuffer();
        }
        this.encode(value);
        if ((double)this.nextWriteBuffer.size() >= (double)this.writeBufferSize * 0.75) {
            this.flushNextWriteBuffer();
        }
        if (wasEmpty) {
            return ProtocolCodec.BufferState.WAS_EMPTY;
        }
        return ProtocolCodec.BufferState.NOT_EMPTY;
    }

    private DataByteArrayOutputStream allocateNextWriteBuffer() {
        if (this.writeBufferPool != null) {
            return new DataByteArrayOutputStream((byte[])this.writeBufferPool.checkout()){

                protected void resize(int newcount) {
                    byte[] oldbuf = this.buf;
                    super.resize(newcount);
                    if (oldbuf.length == AbstractProtocolCodec.this.writeBufferPool.getBufferSize()) {
                        AbstractProtocolCodec.this.writeBufferPool.checkin(oldbuf);
                    }
                }
            };
        }
        return new DataByteArrayOutputStream(this.writeBufferSize);
    }

    protected void flushNextWriteBuffer() {
        DataByteArrayOutputStream next = this.allocateNextWriteBuffer();
        ByteBuffer bb = this.nextWriteBuffer.toBuffer().toByteBuffer();
        this.writeBuffer.add(bb);
        this.writeBufferRemaining += (long)bb.remaining();
        this.nextWriteBuffer = next;
    }

    public ProtocolCodec.BufferState flush() throws IOException {
        block0: while (true) {
            if (this.writeBufferRemaining != 0L) {
                if (this.writeBuffer.size() == 1) {
                    ByteBuffer b = this.writeBuffer.getFirst();
                    this.lastWriteIoSize = this.writeChannel.write(b);
                    if (this.lastWriteIoSize == 0L) {
                        return ProtocolCodec.BufferState.NOT_EMPTY;
                    }
                    this.writeBufferRemaining -= this.lastWriteIoSize;
                    this.writeCounter += this.lastWriteIoSize;
                    if (b.hasRemaining()) continue;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                    continue;
                }
                ByteBuffer[] buffers = this.writeBuffer.toArray(new ByteBuffer[this.writeBuffer.size()]);
                this.lastWriteIoSize = this.writeChannel.write(buffers, 0, buffers.length);
                if (this.lastWriteIoSize == 0L) {
                    return ProtocolCodec.BufferState.NOT_EMPTY;
                }
                this.writeBufferRemaining -= this.lastWriteIoSize;
                this.writeCounter += this.lastWriteIoSize;
                while (true) {
                    if (this.writeBuffer.isEmpty() || this.writeBuffer.getFirst().hasRemaining()) continue block0;
                    this.onBufferFlushed(this.writeBuffer.removeFirst());
                }
            }
            if (this.nextWriteBuffer == null || this.nextWriteBuffer.size() == 0) {
                if (this.writeBufferPool != null && this.nextWriteBuffer != null) {
                    this.writeBufferPool.checkin(this.nextWriteBuffer.getData());
                    this.nextWriteBuffer = null;
                }
                return ProtocolCodec.BufferState.EMPTY;
            }
            this.flushNextWriteBuffer();
        }
    }

    protected void onBufferFlushed(ByteBuffer byteBuffer) {
    }

    protected abstract Action initialDecodeAction();

    public void setReadableByteChannel(ReadableByteChannel channel) throws SocketException {
        this.readChannel = channel;
        if (this.nextDecodeAction == null) {
            this.nextDecodeAction = this.initialDecodeAction();
        }
    }

    public long getReadCounter() {
        return this.readCounter;
    }

    public Object read() throws IOException {
        Object object = null;
        while (object == null) {
            if (this.directReadBuffer != null) {
                while (this.directReadBuffer.hasRemaining()) {
                    this.lastReadIoSize = this.readChannel.read(this.directReadBuffer);
                    this.readCounter += (long)this.lastReadIoSize;
                    if (this.lastReadIoSize == -1) {
                        throw new EOFException("Peer disconnected");
                    }
                    if (this.lastReadIoSize != 0) continue;
                    return null;
                }
                object = this.nextDecodeAction.apply();
                continue;
            }
            if (this.readBuffer == null || this.readEnd == this.readBuffer.position()) {
                int n;
                if (this.readBuffer == null || this.readBuffer.remaining() == 0) {
                    n = this.readEnd - this.readStart;
                    int n2 = 0;
                    n2 = this.readStart == 0 ? n + this.readBufferSize : (n > this.readBufferSize ? n + this.readBufferSize : this.readBufferSize);
                    byte[] byArray = n > 0 ? Arrays.copyOfRange(this.readBuffer.array(), this.readStart, this.readStart + n2) : (this.readBufferPool != null ? (n2 == this.readBufferPool.getBufferSize() ? (byte[])this.readBufferPool.checkout() : new byte[n2]) : (n > 0 ? Arrays.copyOfRange(this.readBuffer.array(), this.readStart, this.readStart + n2) : new byte[n2]));
                    this.readBuffer = ByteBuffer.wrap(byArray);
                    this.readBuffer.position(n);
                    this.readStart = 0;
                    this.readEnd = n;
                }
                n = this.readBuffer.position();
                this.lastReadIoSize = this.readChannel.read(this.readBuffer);
                this.readCounter += (long)this.lastReadIoSize;
                if (this.lastReadIoSize == -1) {
                    ++this.readCounter;
                    throw new EOFException("Peer disconnected");
                }
                if (this.lastReadIoSize == 0) {
                    if (this.readBufferPool != null && this.readStart == this.readEnd) {
                        if (this.readEnd == 0 && this.readBuffer.array().length == this.readBufferPool.getBufferSize()) {
                            this.readBufferPool.checkin(this.readBuffer.array());
                        } else {
                            this.readStart = 0;
                            this.readEnd = 0;
                        }
                        this.readBuffer = null;
                    }
                    return null;
                }
            }
            object = this.nextDecodeAction.apply();
            if (!$assertionsDisabled && this.readStart > this.readEnd) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.readEnd > this.readBuffer.position()) {
                throw new AssertionError();
            }
        }
        return object;
    }

    static {
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$AbstractProtocolCodec;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$AbstractProtocolCodec = new AbstractProtocolCodec[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public static interface Action {
        public Object apply() throws IOException;
    }
}

