/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.AbstractExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionHandler;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicInteger;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.retrotranslator.runtime.java.lang._Thread;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private final AtomicInteger ctl = new AtomicInteger(ThreadPoolExecutor.ctlOf(-536870912, 0));
    private final BlockingQueue workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final HashSet workers = new HashSet();
    private final Condition termination = this.mainLock.newCondition();
    private int largestPoolSize;
    private long completedTaskCount;
    private volatile ThreadFactory threadFactory;
    private volatile RejectedExecutionHandler handler;
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");

    private static int runStateOf(int c) {
        return c & 0xE0000000;
    }

    private static int workerCountOf(int c) {
        return c & 0x1FFFFFFF;
    }

    private static int ctlOf(int rs, int wc) {
        return rs | wc;
    }

    private static boolean runStateLessThan(int c, int s) {
        return c < s;
    }

    private static boolean runStateAtLeast(int c, int s) {
        return c >= s;
    }

    private static boolean isRunning(int c) {
        return c < 0;
    }

    private boolean compareAndIncrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect + 1);
    }

    private boolean compareAndDecrementWorkerCount(int expect) {
        return this.ctl.compareAndSet(expect, expect - 1);
    }

    private void decrementWorkerCount() {
        while (!this.compareAndDecrementWorkerCount(this.ctl.get())) {
        }
    }

    private void advanceRunState(int targetState) {
        int c;
        while (!ThreadPoolExecutor.runStateAtLeast(c = this.ctl.get(), targetState) && !this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(targetState, ThreadPoolExecutor.workerCountOf(c)))) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void tryTerminate() {
        int c;
        while (!(ThreadPoolExecutor.isRunning(c = this.ctl.get()) || ThreadPoolExecutor.runStateAtLeast(c, 0x40000000) || ThreadPoolExecutor.runStateOf(c) == 0 && !this.workQueue.isEmpty())) {
            if (ThreadPoolExecutor.workerCountOf(c) != 0) {
                this.interruptIdleWorkers(true);
                return;
            }
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (!this.ctl.compareAndSet(c, ThreadPoolExecutor.ctlOf(0x40000000, 0))) continue;
                try {
                    this.terminated();
                    Object var4_3 = null;
                    this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                    this.termination.signalAll();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.ctl.set(ThreadPoolExecutor.ctlOf(0x60000000, 0));
                    this.termination.signalAll();
                    throw throwable;
                }
                return;
            }
            finally {
                mainLock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkShutdownAccess() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(shutdownPerm);
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                Iterator itr = this.workers.iterator();
                while (itr.hasNext()) {
                    Worker w = (Worker)itr.next();
                    security.checkAccess(w.thread);
                }
            }
            finally {
                mainLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptIdleWorkers(boolean onlyOne) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            Iterator it = this.workers.iterator();
            while (it.hasNext()) {
                Worker w = (Worker)it.next();
                Thread t = w.thread;
                if (!t.isInterrupted() && w.tryLock()) {
                    try {
                        t.interrupt();
                    }
                    catch (SecurityException ignore) {
                    }
                    finally {
                        w.unlock();
                    }
                }
                if (!onlyOne) continue;
                break;
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    private void interruptIdleWorkers() {
        this.interruptIdleWorkers(false);
    }

    private void clearInterruptsForTaskRun() {
        if (ThreadPoolExecutor.runStateLessThan(this.ctl.get(), 0x20000000) && Thread.interrupted() && ThreadPoolExecutor.runStateAtLeast(this.ctl.get(), 0x20000000)) {
            Thread.currentThread().interrupt();
        }
    }

    final void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    void onShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addWorker(Runnable firstTask, boolean core) {
        block4: while (true) {
            int c;
            int rs;
            if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs != 0 || firstTask != null || this.workQueue.isEmpty())) {
                return false;
            }
            do {
                int wc;
                if ((wc = ThreadPoolExecutor.workerCountOf(c)) >= 0x1FFFFFFF || wc >= (core ? this.corePoolSize : this.maximumPoolSize)) {
                    return false;
                }
                if (this.compareAndIncrementWorkerCount(c)) break block4;
            } while (ThreadPoolExecutor.runStateOf(c = this.ctl.get()) == rs);
        }
        Worker w = new Worker(firstTask);
        Thread t = w.thread;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int c = this.ctl.get();
            int rs = ThreadPoolExecutor.runStateOf(c);
            if (t == null || rs >= 0 && (rs != 0 || firstTask != null)) {
                this.decrementWorkerCount();
                this.tryTerminate();
                boolean bl = false;
                return bl;
            }
            this.workers.add(w);
            int s = this.workers.size();
            if (s > this.largestPoolSize) {
                this.largestPoolSize = s;
            }
        }
        finally {
            mainLock.unlock();
        }
        _Thread.start(t);
        if (ThreadPoolExecutor.runStateOf(this.ctl.get()) == 0x20000000 && !t.isInterrupted()) {
            t.interrupt();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWorkerExit(Worker w, boolean completedAbruptly) {
        if (completedAbruptly) {
            this.decrementWorkerCount();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
        int c = this.ctl.get();
        if (ThreadPoolExecutor.runStateLessThan(c, 0x20000000)) {
            if (!completedAbruptly) {
                int min;
                int n = min = this.allowCoreThreadTimeOut ? 0 : this.corePoolSize;
                if (min == 0 && !this.workQueue.isEmpty()) {
                    min = 1;
                }
                if (ThreadPoolExecutor.workerCountOf(c) >= min) {
                    return;
                }
            }
            this.addWorker(null, false);
        }
    }

    private Runnable getTask() {
        boolean timedOut = false;
        while (true) {
            boolean timed;
            block6: {
                int c;
                int rs;
                if ((rs = ThreadPoolExecutor.runStateOf(c = this.ctl.get())) >= 0 && (rs >= 0x20000000 || this.workQueue.isEmpty())) {
                    this.decrementWorkerCount();
                    return null;
                }
                do {
                    int wc = ThreadPoolExecutor.workerCountOf(c);
                    boolean bl = timed = this.allowCoreThreadTimeOut || wc > this.corePoolSize;
                    if (wc <= this.maximumPoolSize && (!timedOut || !timed)) break block6;
                    if (!this.compareAndDecrementWorkerCount(c)) continue;
                    return null;
                } while (ThreadPoolExecutor.runStateOf(c = this.ctl.get()) == rs);
                continue;
            }
            try {
                Runnable r;
                Runnable runnable = r = timed ? (Runnable)this.workQueue.poll(this.keepAliveTime, TimeUnit.NANOSECONDS) : (Runnable)this.workQueue.take();
                if (r != null) {
                    return r;
                }
                timedOut = true;
                continue;
            }
            catch (InterruptedException retry) {
                timedOut = false;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runWorker(Worker w) {
        Runnable task = w.firstTask;
        w.firstTask = null;
        boolean completedAbruptly = true;
        try {
            while (task != null || (task = this.getTask()) != null) {
                w.lock();
                this.clearInterruptsForTaskRun();
                try {
                    this.beforeExecute(w.thread, task);
                    Throwable thrown = null;
                    try {
                        task.run();
                    }
                    catch (RuntimeException x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Error x) {
                        thrown = x;
                        throw x;
                    }
                    catch (Throwable x) {
                        thrown = x;
                        throw new Error(x);
                    }
                    finally {
                        this.afterExecute(task, thrown);
                    }
                }
                finally {
                    task = null;
                    ++w.completedTasks;
                    w.unlock();
                }
            }
            completedAbruptly = false;
        }
        finally {
            this.processWorkerExit(w, completedAbruptly);
        }
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    public void execute(Runnable command) {
        if (command == null) {
            throw new NullPointerException();
        }
        int c = this.ctl.get();
        if (ThreadPoolExecutor.workerCountOf(c) < this.corePoolSize) {
            if (this.addWorker(command, true)) {
                return;
            }
            c = this.ctl.get();
        }
        if (ThreadPoolExecutor.isRunning(c) && this.workQueue.offer(command)) {
            int recheck = this.ctl.get();
            if (!ThreadPoolExecutor.isRunning(recheck) && this.remove(command)) {
                this.reject(command);
            } else if (ThreadPoolExecutor.workerCountOf(recheck) == 0) {
                this.addWorker(null, false);
            }
        } else if (!this.addWorker(command, false)) {
            this.reject(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.checkShutdownAccess();
            this.advanceRunState(0);
            this.interruptIdleWorkers();
            this.onShutdown();
        }
        finally {
            mainLock.unlock();
        }
        this.tryTerminate();
    }

    protected void finalize() {
        this.shutdown();
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public boolean remove(Runnable task) {
        boolean removed = this.workQueue.remove(task);
        this.tryTerminate();
        return removed;
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    private final class Worker
    extends ReentrantLock
    implements Runnable {
        final Thread thread;
        Runnable firstTask;
        volatile long completedTasks;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
            this.thread = ThreadPoolExecutor.this.getThreadFactory().newThread(this);
        }

        public void run() {
            ThreadPoolExecutor.this.runWorker(this);
        }
    }
}

