/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.transport.TcpTransport;

public class SslTransport
extends TcpTransport {
    private ClientAuth clientAuth = ClientAuth.WANT;
    private String disabledCypherSuites = null;
    private String enabledCipherSuites = null;
    private SSLContext sslContext;
    private SSLEngine engine;
    private ByteBuffer readBuffer;
    private boolean readUnderflow;
    private ByteBuffer writeBuffer;
    private boolean writeFlushing;
    private ByteBuffer readOverflowBuffer;
    private SSLChannel ssl_channel = new SSLChannel();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$hawtdispatch$transport$SslTransport;

    public static String protocol(String scheme) {
        if (scheme.equals("tls")) {
            return "TLS";
        }
        if (scheme.startsWith("tlsv")) {
            return "TLSv" + scheme.substring(4);
        }
        if (scheme.equals("ssl")) {
            return "SSL";
        }
        if (scheme.startsWith("sslv")) {
            return "SSLv" + scheme.substring(4);
        }
        return null;
    }

    public void setSSLContext(SSLContext ctx) {
        this.sslContext = ctx;
    }

    public void connecting(URI remoteLocation, URI localLocation) throws Exception {
        if (!$assertionsDisabled && this.engine != null) {
            throw new AssertionError();
        }
        this.engine = this.sslContext.createSSLEngine(remoteLocation.getHost(), remoteLocation.getPort());
        this.engine.setUseClientMode(true);
        super.connecting(remoteLocation, localLocation);
    }

    protected void initializeChannel() throws Exception {
        super.initializeChannel();
        SSLSession session = this.engine.getSession();
        this.readBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.readBuffer.flip();
        this.writeBuffer = ByteBuffer.allocateDirect(session.getPacketBufferSize());
    }

    protected void onConnected() throws IOException {
        super.onConnected();
        this.engine.beginHandshake();
        this.handshake();
    }

    public void flush() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        } else {
            super.flush();
        }
    }

    public void drainInbound() {
        if (this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.handshake();
        } else {
            super.drainInbound();
        }
    }

    protected boolean transportFlush() throws IOException {
        while (true) {
            if (this.writeFlushing) {
                int count = super.getWriteChannel().write(this.writeBuffer);
                if (!this.writeBuffer.hasRemaining()) {
                    this.writeBuffer.clear();
                    this.writeFlushing = false;
                    this.suspendWrite();
                    return true;
                }
                return false;
            }
            if (this.writeBuffer.position() == 0) break;
            this.writeBuffer.flip();
            this.writeFlushing = true;
            this.resumeWrite();
        }
        return true;
    }

    private int secure_write(ByteBuffer plain) throws IOException {
        if (!this.transportFlush()) {
            return 0;
        }
        int rc = 0;
        while (plain.hasRemaining() ^ this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            SSLEngineResult result = this.engine.wrap(plain, this.writeBuffer);
            if (!$assertionsDisabled && result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                throw new AssertionError();
            }
            rc += result.bytesConsumed();
            if (this.transportFlush() && result.getStatus() != SSLEngineResult.Status.CLOSED) continue;
            break;
        }
        if (plain.remaining() == 0 && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            this.dispatchQueue.execute(new Task(){

                public void run() {
                    SslTransport.this.handshake();
                }
            });
        }
        return rc;
    }

    private int secure_read(ByteBuffer plain) throws IOException {
        int rc = 0;
        while (plain.hasRemaining() ^ this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.readOverflowBuffer != null) {
                if (plain.hasRemaining()) {
                    int size = Math.min(plain.remaining(), this.readOverflowBuffer.remaining());
                    plain.put(this.readOverflowBuffer.array(), this.readOverflowBuffer.position(), size);
                    this.readOverflowBuffer.position(this.readOverflowBuffer.position() + size);
                    if (!this.readOverflowBuffer.hasRemaining()) {
                        this.readOverflowBuffer = null;
                    }
                    rc += size;
                    continue;
                }
                return rc;
            }
            if (this.readUnderflow) {
                int count = super.getReadChannel().read(this.readBuffer);
                if (count == -1) {
                    if (rc == 0) {
                        return -1;
                    }
                    return rc;
                }
                if (count == 0) {
                    return rc;
                }
                this.readUnderflow = false;
                this.readBuffer.flip();
                continue;
            }
            SSLEngineResult result = this.engine.unwrap(this.readBuffer, plain);
            rc += result.bytesProduced();
            if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                this.readOverflowBuffer = ByteBuffer.allocate(this.engine.getSession().getApplicationBufferSize());
                result = this.engine.unwrap(this.readBuffer, this.readOverflowBuffer);
                if (this.readOverflowBuffer.position() == 0) {
                    this.readOverflowBuffer = null;
                } else {
                    this.readOverflowBuffer.flip();
                }
            }
            switch (4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[result.getStatus().ordinal()]) {
                case 1: {
                    if (rc == 0) {
                        this.engine.closeInbound();
                        return -1;
                    }
                    return rc;
                }
                case 2: {
                    if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) break;
                    this.dispatchQueue.execute(new Task(){

                        public void run() {
                            SslTransport.this.handshake();
                        }
                    });
                    break;
                }
                case 3: {
                    this.readBuffer.compact();
                    this.readUnderflow = true;
                    break;
                }
                case 4: {
                    throw new AssertionError((Object)"Unexpected case.");
                }
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handshake() {
        try {
            if (!this.transportFlush()) {
                return;
            }
            switch (4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[this.engine.getHandshakeStatus().ordinal()]) {
                case 1: {
                    final Runnable task = this.engine.getDelegatedTask();
                    if (task == null) return;
                    this.blockingExecutor.execute(new Task(){

                        public void run() {
                            task.run();
                            SslTransport.this.dispatchQueue.execute(new Task(){

                                public void run() {
                                    if (SslTransport.this.isConnected()) {
                                        SslTransport.this.handshake();
                                    }
                                }
                            });
                        }
                    });
                    return;
                }
                case 2: {
                    this.secure_write(ByteBuffer.allocate(0));
                    return;
                }
                case 3: {
                    if (this.secure_read(ByteBuffer.allocate(0)) != -1) return;
                    throw new EOFException("Peer disconnected during ssl handshake");
                }
                case 4: 
                case 5: {
                    return;
                }
                default: {
                    System.err.println("Unexpected ssl engine handshake status: " + (Object)((Object)this.engine.getHandshakeStatus()));
                    return;
                }
            }
        }
        catch (IOException e) {
            this.onTransportFailure(e);
            return;
        }
        finally {
            if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                this.drainOutboundSource.merge(_Integer.valueOf(1));
                super.drainInbound();
            }
        }
    }

    public ReadableByteChannel getReadChannel() {
        return this.ssl_channel;
    }

    public WritableByteChannel getWriteChannel() {
        return this.ssl_channel;
    }

    static {
        Class<?> clazz = class$org$fusesource$hawtdispatch$transport$SslTransport;
        if (clazz == null) {
            clazz = class$org$fusesource$hawtdispatch$transport$SslTransport = new SslTransport[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$org$fusesource$hawtdispatch$transport$SslTransport$ClientAuth;
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$Status;
        static final /* synthetic */ int[] $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus;

        static {
            $SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus = new int[SSLEngineResult.HandshakeStatus.values().length];
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_TASK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_WRAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NEED_UNWRAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.FINISHED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$javax$net$ssl$SSLEngineResult$Status = new int[SSLEngineResult.Status.values().length];
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.CLOSED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.BUFFER_UNDERFLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[SSLEngineResult.Status.BUFFER_OVERFLOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $SwitchMap$org$fusesource$hawtdispatch$transport$SslTransport$ClientAuth = new int[ClientAuth.values().length];
            try {
                4.$SwitchMap$org$fusesource$hawtdispatch$transport$SslTransport$ClientAuth[ClientAuth.WANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$fusesource$hawtdispatch$transport$SslTransport$ClientAuth[ClientAuth.NEED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$org$fusesource$hawtdispatch$transport$SslTransport$ClientAuth[ClientAuth.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public class SSLChannel
    implements GatheringByteChannel,
    ScatteringByteChannel {
        public int write(ByteBuffer plain) throws IOException {
            return SslTransport.this.secure_write(plain);
        }

        public int read(ByteBuffer plain) throws IOException {
            return SslTransport.this.secure_read(plain);
        }

        public boolean isOpen() {
            return SslTransport.this.getSocketChannel().isOpen();
        }

        public void close() throws IOException {
            SslTransport.this.getSocketChannel().close();
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            if (offset + length > srcs.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer src = srcs[offset + i];
                if (src.hasRemaining()) {
                    rc += (long)this.write(src);
                }
                if (!src.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            if (offset + length > dsts.length || length < 0 || offset < 0) {
                throw new IndexOutOfBoundsException();
            }
            long rc = 0L;
            for (int i = 0; i < length; ++i) {
                ByteBuffer dst = dsts[offset + i];
                if (dst.hasRemaining()) {
                    rc += (long)this.read(dst);
                }
                if (!dst.hasRemaining()) continue;
                return rc;
            }
            return rc;
        }

        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        public Socket socket() {
            SocketChannel c = SslTransport.this.channel;
            if (c == null) {
                return null;
            }
            return c.socket();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class ClientAuth
    extends Enum_<ClientAuth> {
        public static final ClientAuth WANT = new ClientAuth("WANT", 0);
        public static final ClientAuth NEED = new ClientAuth("NEED", 1);
        public static final ClientAuth NONE = new ClientAuth("NONE", 2);
        private static final /* synthetic */ ClientAuth[] $VALUES;

        public static ClientAuth[] values() {
            return (ClientAuth[])$VALUES.clone();
        }

        private ClientAuth() {
            super(var1_1, n);
        }

        static {
            $VALUES = new ClientAuth[]{WANT, NEED, NONE};
        }
    }
}

