/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.pool;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import java.io.IOException;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.GlobalDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtThreadGroup;
import org.fusesource.hawtdispatch.internal.NioManager;
import org.fusesource.hawtdispatch.internal.WorkerPool;
import org.fusesource.hawtdispatch.internal.WorkerThread;
import org.fusesource.hawtdispatch.internal.pool.SimpleThread;

public class SimplePool
implements WorkerPool {
    final ConcurrentLinkedQueue<Task> tasks = new ConcurrentLinkedQueue();
    final GlobalDispatchQueue globalQueue;
    final String name;
    final int priority;
    final SimpleThread[] threads;
    volatile boolean shutdown = false;
    final ThreadGroup group;

    public SimplePool(GlobalDispatchQueue globalQueue, int parallelism, DispatchPriority priority) {
        this.globalQueue = globalQueue;
        this.name = globalQueue.dispatcher.getLabel() + "-" + priority;
        this.group = new HawtThreadGroup(globalQueue.dispatcher, this.name);
        this.priority = SimplePool.priority(priority);
        this.threads = new SimpleThread[parallelism];
    }

    private static int priority(DispatchPriority priority) {
        switch (1.$SwitchMap$org$fusesource$hawtdispatch$DispatchPriority[priority.ordinal()]) {
            case 1: {
                return 10;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public void start() {
        this.shutdown = false;
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = this.createWorker(i);
            this.threads[i].start();
        }
    }

    private SimpleThread createWorker(int index) {
        SimpleThread w;
        try {
            w = new SimpleThread(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        w.setDaemon(true);
        w.setPriority(this.priority);
        w.setName(this.name + "-" + (index + 1));
        return w;
    }

    public WorkerThread[] getThreads() {
        return this.threads;
    }

    public void execute(Task runnable) {
        NioManager nio;
        WorkerThread current = WorkerThread.currentWorkerThread();
        this.tasks.add((Object)runnable);
        for (int i = 0; !(i >= this.threads.length || this.threads[i] != current && (nio = this.threads[i].getNioManager()).wakeupIfSelecting()); ++i) {
        }
    }

    public void park(SimpleThread thread) {
        try {
            this.debug("parking thread: %s", new Object[]{thread.getName()});
            thread.getNioManager().select(-1L);
            this.debug("unparking thread: %s", new Object[]{thread.getName()});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void debug(String str, Object[] args) {
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$fusesource$hawtdispatch$DispatchPriority;

        static {
            $SwitchMap$org$fusesource$hawtdispatch$DispatchPriority = new int[DispatchPriority.values().length];
            try {
                1.$SwitchMap$org$fusesource$hawtdispatch$DispatchPriority[DispatchPriority.HIGH.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$fusesource$hawtdispatch$DispatchPriority[DispatchPriority.DEFAULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$fusesource$hawtdispatch$DispatchPriority[DispatchPriority.LOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

