/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.retrotranslator.runtime.java.lang.Enum_;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.util.TimerHeap;

public final class TimerThread
extends Thread {
    private final Object mutex = new Object();
    private ArrayList<TimerRequest> requests = new ArrayList();

    public TimerThread(HawtDispatcher dispatcher) {
        this.setName(dispatcher.getLabel() + " timer");
        this.setDaemon(true);
    }

    public final void addRelative(Task task, DispatchQueue target, long delay, TimeUnit unit) {
        TimerRequest request = new TimerRequest();
        request.type = Type.RELATIVE;
        request.time = delay;
        request.unit = unit;
        request.task = task;
        request.target = target;
        this.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(TimerRequest request) {
        Object object = this.mutex;
        synchronized (object) {
            this.requests.add(request);
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        ArrayList<Object> swapped;
        TimerHeap<TimerRequest> timerHeap;
        HashMap readyRequests;
        try {
            readyRequests = new HashMap();
            timerHeap = new TimerHeap<TimerRequest>(){

                @Override
                public final void execute(TimerRequest request) {
                    LinkedList<Task> tasks = (LinkedList<Task>)readyRequests.get(request.target);
                    if (tasks == null) {
                        tasks = new LinkedList<Task>();
                        readyRequests.put(request.target, tasks);
                    }
                    tasks.add(request.task);
                }

                @Override
                public /* synthetic */ void execute(Object x0) {
                    this.execute((TimerRequest)x0);
                }
            };
            swapped = new ArrayList();
            try {}
            catch (InterruptedException e) {
                return;
            }
        }
        catch (Throwable throwable) {
            _Thread.handleUncaughtException(throwable);
            return;
        }
        block13: while (true) {
            Iterator<Object> i$;
            Object object = this.mutex;
            // MONITORENTER : object
            ArrayList<TimerRequest> t = this.requests;
            this.requests = swapped;
            swapped = t;
            // MONITOREXIT : object
            if (!swapped.isEmpty()) {
                i$ = swapped.iterator();
                while (i$.hasNext()) {
                    TimerRequest request = (TimerRequest)i$.next();
                    switch (3.$SwitchMap$org$fusesource$hawtdispatch$internal$TimerThread$Type[request.type.ordinal()]) {
                        case 1: {
                            timerHeap.addRelative(request, request.time, request.unit);
                            break;
                        }
                        case 2: {
                            timerHeap.addAbsolute(request, request.time, request.unit);
                            break;
                        }
                        case 3: {
                            List requests = timerHeap.clear();
                            Iterator i$2 = requests.iterator();
                            while (true) {
                                if (!i$2.hasNext()) {
                                    if (request.task == null) return;
                                    request.task.run();
                                    return;
                                }
                                TimerRequest r = (TimerRequest)i$2.next();
                                r.target.execute(r.task);
                            }
                        }
                    }
                }
                swapped.clear();
            }
            timerHeap.executeReadyTimers();
            if (!readyRequests.isEmpty()) {
                i$ = readyRequests.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry entry = (Map.Entry)i$.next();
                    DispatchQueue queue = (DispatchQueue)entry.getKey();
                    final LinkedList tasks = (LinkedList)entry.getValue();
                    if (tasks.size() > 1) {
                        queue.execute(new Task(){

                            public void run() {
                                Iterator i$ = tasks.iterator();
                                while (i$.hasNext()) {
                                    Task task = (Task)i$.next();
                                    task.run();
                                }
                            }
                        });
                        continue;
                    }
                    queue.execute((Task)tasks.getFirst());
                }
                readyRequests.clear();
            }
            long start = Utils.nanoTime();
            long next = timerHeap.timeToNext(TimeUnit.NANOSECONDS);
            if (next == 0L) continue;
            if (next > 0L && next < 1000L) {
                while (true) {
                    if (Utils.nanoTime() - start >= next) continue block13;
                }
            }
            long waitms = next / 1000000L;
            int waitns = (int)(next % 1000000L);
            Object object2 = this.mutex;
            // MONITORENTER : object2
            if (this.requests.isEmpty()) {
                if (next == -1L) {
                    this.mutex.wait();
                } else {
                    this.mutex.wait(waitms, waitns);
                }
            }
            // MONITOREXIT : object2
        }
    }

    static class 3 {
        static final /* synthetic */ int[] $SwitchMap$org$fusesource$hawtdispatch$internal$TimerThread$Type;

        static {
            $SwitchMap$org$fusesource$hawtdispatch$internal$TimerThread$Type = new int[Type.values().length];
            try {
                3.$SwitchMap$org$fusesource$hawtdispatch$internal$TimerThread$Type[Type.RELATIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$fusesource$hawtdispatch$internal$TimerThread$Type[Type.ABSOLUTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                3.$SwitchMap$org$fusesource$hawtdispatch$internal$TimerThread$Type[Type.SHUTDOWN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static final class TimerRequest {
        Type type;
        long time;
        TimeUnit unit;
        Task task;
        DispatchQueue target;

        private TimerRequest() {
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Type
    extends Enum_<Type> {
        public static final Type RELATIVE = new Type("RELATIVE", 0);
        public static final Type ABSOLUTE = new Type("ABSOLUTE", 1);
        public static final Type SHUTDOWN = new Type("SHUTDOWN", 2);
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        private Type() {
            super(var1_1, n);
        }

        static {
            $VALUES = new Type[]{RELATIVE, ABSOLUTE, SHUTDOWN};
        }
    }
}

