/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.client;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.SynchronousQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import net.sf.retrotranslator.runtime.java.lang._System;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.FutureConnection;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Tracer;
import org.fusesource.mqtt.codec.CONNECT;

public class MQTT {
    private static final long KEEP_ALIVE = Long.parseLong(_System.getProperty("mqtt.thread.keep_alive", Integer.toString(1000)));
    private static final long STACK_SIZE = Long.parseLong(_System.getProperty("mqtt.thread.stack_size", Integer.toString(524288)));
    private static ThreadPoolExecutor blockingThreadPool;
    private static final URI DEFAULT_HOST;
    URI host = DEFAULT_HOST;
    URI localAddress;
    SSLContext sslContext;
    DispatchQueue dispatchQueue;
    Executor blockingExecutor;
    int maxReadRate;
    int maxWriteRate;
    int trafficClass = 8;
    int receiveBufferSize = 65536;
    int sendBufferSize = 65536;
    boolean useLocalHost = true;
    CONNECT connect = new CONNECT();
    long reconnectDelay = 10L;
    long reconnectDelayMax = 30000L;
    double reconnectBackOffMultiplier = 2.0;
    long reconnectAttemptsMax = -1L;
    long connectAttemptsMax = -1L;
    Tracer tracer = new Tracer();

    public static synchronized ThreadPoolExecutor getBlockingThreadPool() {
        if (blockingThreadPool == null) {
            blockingThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, KEEP_ALIVE, TimeUnit.MILLISECONDS, (BlockingQueue)new SynchronousQueue(), new ThreadFactory(){

                public Thread newThread(Runnable r) {
                    _Thread.AdvancedThreadBuilder advancedThreadBuilder = _Thread.createInstanceBuilder(null, r, "MQTT Task", STACK_SIZE);
                    Thread rc = new Thread(advancedThreadBuilder.argument1(), advancedThreadBuilder.argument2(), advancedThreadBuilder.argument3(), advancedThreadBuilder.argument4());
                    rc.setDaemon(true);
                    return rc;
                }
            }){

                @Override
                public void shutdown() {
                }

                @Override
                public List<Runnable> shutdownNow() {
                    return Collections.EMPTY_LIST;
                }
            };
        }
        return blockingThreadPool;
    }

    public static synchronized void setBlockingThreadPool(ThreadPoolExecutor pool) {
        blockingThreadPool = pool;
    }

    private static URI createDefaultHost() {
        try {
            return new URI("tcp://127.0.0.1:1883");
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public MQTT() {
    }

    public MQTT(MQTT other) {
        this.host = other.host;
        this.localAddress = other.localAddress;
        this.sslContext = other.sslContext;
        this.dispatchQueue = other.dispatchQueue;
        this.blockingExecutor = other.blockingExecutor;
        this.maxReadRate = other.maxReadRate;
        this.maxWriteRate = other.maxWriteRate;
        this.trafficClass = other.trafficClass;
        this.receiveBufferSize = other.receiveBufferSize;
        this.sendBufferSize = other.sendBufferSize;
        this.useLocalHost = other.useLocalHost;
        this.connect = new CONNECT(other.connect);
        this.reconnectDelay = other.reconnectDelay;
        this.reconnectDelayMax = other.reconnectDelayMax;
        this.reconnectBackOffMultiplier = other.reconnectBackOffMultiplier;
        this.reconnectAttemptsMax = other.reconnectAttemptsMax;
        this.connectAttemptsMax = other.connectAttemptsMax;
        this.tracer = other.tracer;
    }

    public CallbackConnection callbackConnection() {
        if (!(this.isCleanSession() || this.getClientId() != null && this.getClientId().length != 0)) {
            throw new IllegalArgumentException("The client id MUST be configured when clean session is set to false");
        }
        return new CallbackConnection(new MQTT(this));
    }

    public FutureConnection futureConnection() {
        return new FutureConnection(this.callbackConnection());
    }

    public BlockingConnection blockingConnection() {
        return new BlockingConnection(this.futureConnection());
    }

    public UTF8Buffer getClientId() {
        return this.connect.clientId();
    }

    public short getKeepAlive() {
        return this.connect.keepAlive();
    }

    public UTF8Buffer getPassword() {
        return this.connect.password();
    }

    public byte getType() {
        return this.connect.messageType();
    }

    public UTF8Buffer getUserName() {
        return this.connect.userName();
    }

    public UTF8Buffer getWillMessage() {
        return this.connect.willMessage();
    }

    public QoS getWillQos() {
        return this.connect.willQos();
    }

    public UTF8Buffer getWillTopic() {
        return this.connect.willTopic();
    }

    public boolean isCleanSession() {
        return this.connect.cleanSession();
    }

    public boolean isWillRetain() {
        return this.connect.willRetain();
    }

    public void setCleanSession(boolean cleanSession) {
        this.connect.cleanSession(cleanSession);
    }

    public void setClientId(String clientId) {
        this.setClientId(Buffer.utf8(clientId));
    }

    public void setClientId(UTF8Buffer clientId) {
        this.connect.clientId(clientId);
    }

    public void setKeepAlive(short keepAlive) {
        this.connect.keepAlive(keepAlive);
    }

    public void setPassword(String password) {
        this.setPassword(Buffer.utf8(password));
    }

    public void setPassword(UTF8Buffer password) {
        this.connect.password(password);
    }

    public void setUserName(String userName) {
        this.setUserName(Buffer.utf8(userName));
    }

    public void setUserName(UTF8Buffer userName) {
        this.connect.userName(userName);
    }

    public void setWillMessage(String willMessage) {
        this.connect.willMessage(Buffer.utf8(willMessage));
    }

    public void setWillMessage(UTF8Buffer willMessage) {
        this.connect.willMessage(willMessage);
    }

    public void setWillQos(QoS willQos) {
        this.connect.willQos(willQos);
    }

    public void setVersion(String version) {
        if ("3.1".equals(version)) {
            this.connect.version(3);
        } else if ("3.1.1".equals(version)) {
            this.connect.version(4);
        }
    }

    public String getVersion() {
        switch (this.connect.version()) {
            case 3: {
                return "3.1";
            }
            case 4: {
                return "3.1.1";
            }
        }
        return "unknown";
    }

    public void setWillRetain(boolean willRetain) {
        this.connect.willRetain(willRetain);
    }

    public void setWillTopic(String willTopic) {
        this.setWillTopic(Buffer.utf8(willTopic));
    }

    public void setWillTopic(UTF8Buffer willTopic) {
        this.connect.willTopic(willTopic);
    }

    public Executor getBlockingExecutor() {
        return this.blockingExecutor;
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        this.blockingExecutor = blockingExecutor;
    }

    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    public URI getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) throws URISyntaxException {
        this.setLocalAddress(new URI(localAddress));
    }

    public void setLocalAddress(URI localAddress) {
        this.localAddress = localAddress;
    }

    public int getMaxReadRate() {
        return this.maxReadRate;
    }

    public void setMaxReadRate(int maxReadRate) {
        this.maxReadRate = maxReadRate;
    }

    public int getMaxWriteRate() {
        return this.maxWriteRate;
    }

    public void setMaxWriteRate(int maxWriteRate) {
        this.maxWriteRate = maxWriteRate;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public URI getHost() {
        return this.host;
    }

    public void setHost(String host, int port) throws URISyntaxException {
        this.setHost(new URI("tcp://" + host + ":" + port));
    }

    public void setHost(String host) throws URISyntaxException {
        this.setHost(new URI(host));
    }

    public void setHost(URI host) {
        this.host = host;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public int getTrafficClass() {
        return this.trafficClass;
    }

    public void setTrafficClass(int trafficClass) {
        this.trafficClass = trafficClass;
    }

    public boolean isUseLocalHost() {
        return this.useLocalHost;
    }

    public void setUseLocalHost(boolean useLocalHost) {
        this.useLocalHost = useLocalHost;
    }

    public long getConnectAttemptsMax() {
        return this.connectAttemptsMax;
    }

    public void setConnectAttemptsMax(long connectAttemptsMax) {
        this.connectAttemptsMax = connectAttemptsMax;
    }

    public long getReconnectAttemptsMax() {
        return this.reconnectAttemptsMax;
    }

    public void setReconnectAttemptsMax(long reconnectAttemptsMax) {
        this.reconnectAttemptsMax = reconnectAttemptsMax;
    }

    public double getReconnectBackOffMultiplier() {
        return this.reconnectBackOffMultiplier;
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        this.reconnectBackOffMultiplier = reconnectBackOffMultiplier;
    }

    public long getReconnectDelay() {
        return this.reconnectDelay;
    }

    public void setReconnectDelay(long reconnectDelay) {
        this.reconnectDelay = reconnectDelay;
    }

    public long getReconnectDelayMax() {
        return this.reconnectDelayMax;
    }

    public void setReconnectDelayMax(long reconnectDelayMax) {
        this.reconnectDelayMax = reconnectDelayMax;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    static {
        DEFAULT_HOST = MQTT.createDefaultHost();
    }
}

