/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import java.io.Serializable;

class FIFOCondVar
extends CondVar
implements Condition,
Serializable {
    private static final WaitQueue.QueuedSync sync = new WaitQueue.QueuedSync(){

        public boolean recheck(WaitQueue.WaitNode node) {
            return false;
        }

        public void takeOver(WaitQueue.WaitNode node) {
        }
    };
    private final WaitQueue wq = new FIFOWaitQueue();

    FIFOCondVar(CondVar.ExclusiveLock lock) {
        super(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        int holdCount = this.lock.getHoldCount();
        if (holdCount == 0) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        boolean success = false;
        for (int i = holdCount; i > 0; --i) {
            this.lock.unlock();
        }
        try {
            success = n.doTimedWait(sync, nanos);
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            for (int i = holdCount; i > 0; --i) {
                this.lock.lock();
            }
            throw throwable;
        }
        for (int i = holdCount; i > 0; --i) {
            this.lock.lock();
        }
        return success;
    }

    public void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode w;
        while ((w = this.wq.extract()) != null) {
            w.signal(sync);
        }
        return;
    }
}

