/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Arrays;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.hawtbuf.DataByteArrayOutputStream;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.MessageSupport;

public class UNSUBSCRIBE
extends MessageSupport.HeaderBase
implements MessageSupport.Acked,
MessageSupport.Message {
    public static final byte TYPE = 10;
    public static final UTF8Buffer[] NO_TOPICS;
    private short messageId;
    private UTF8Buffer[] topics = NO_TOPICS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$fusesource$mqtt$codec$UNSUBSCRIBE;

    public UNSUBSCRIBE() {
        this.qos(QoS.AT_LEAST_ONCE);
    }

    public byte messageType() {
        return 10;
    }

    public UNSUBSCRIBE decode(MQTTFrame frame) throws ProtocolException {
        if (!$assertionsDisabled && frame.buffers.length != 1) {
            throw new AssertionError();
        }
        this.header(frame.header());
        DataByteArrayInputStream is = new DataByteArrayInputStream(frame.buffers[0]);
        this.messageId = is.readShort();
        ArrayList<UTF8Buffer> list = new ArrayList<UTF8Buffer>();
        while (is.available() > 0) {
            list.add(MessageSupport.readUTF(is));
        }
        this.topics = list.toArray(new UTF8Buffer[list.size()]);
        return this;
    }

    public MQTTFrame encode() {
        try {
            DataByteArrayOutputStream os = new DataByteArrayOutputStream();
            QoS qos = this.qos();
            if (qos != QoS.AT_MOST_ONCE) {
                os.writeShort(this.messageId);
            }
            UTF8Buffer[] arr$ = this.topics;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                UTF8Buffer topic = arr$[i$];
                MessageSupport.writeUTF(os, topic);
            }
            MQTTFrame frame = new MQTTFrame();
            frame.header(this.header());
            frame.commandType(10);
            return frame.buffer(os.toBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException("The impossible happened");
        }
    }

    public boolean dup() {
        return super.dup();
    }

    public UNSUBSCRIBE dup(boolean dup) {
        return (UNSUBSCRIBE)super.dup(dup);
    }

    public QoS qos() {
        return super.qos();
    }

    public short messageId() {
        return this.messageId;
    }

    public UNSUBSCRIBE messageId(short messageId) {
        this.messageId = messageId;
        return this;
    }

    public UTF8Buffer[] topics() {
        return this.topics;
    }

    public UNSUBSCRIBE topics(UTF8Buffer[] topics) {
        this.topics = topics;
        return this;
    }

    public String toString() {
        return "UNSUBSCRIBE{dup=" + this.dup() + ", qos=" + this.qos() + ", messageId=" + this.messageId + ", topics=" + (this.topics == null ? null : Arrays.asList(this.topics)) + '}';
    }

    public /* synthetic */ MessageSupport.HeaderBase dup(boolean x0) {
        return this.dup(x0);
    }

    public /* synthetic */ MessageSupport.Message decode(MQTTFrame x0) throws ProtocolException {
        return this.decode(x0);
    }

    public /* synthetic */ MessageSupport.Acked messageId(short x0) {
        return this.messageId(x0);
    }

    public /* synthetic */ MessageSupport.Acked dup(boolean x0) {
        return this.dup(x0);
    }

    static {
        Class<?> clazz = class$org$fusesource$mqtt$codec$UNSUBSCRIBE;
        if (clazz == null) {
            clazz = class$org$fusesource$mqtt$codec$UNSUBSCRIBE = new UNSUBSCRIBE[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NO_TOPICS = new UTF8Buffer[0];
    }
}

