/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.pool;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import java.io.IOException;
import net.sf.retrotranslator.runtime.java.util._LinkedList;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.NioManager;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;
import org.fusesource.hawtdispatch.internal.WorkerThread;
import org.fusesource.hawtdispatch.internal.pool.SimplePool;

public class SimpleThread
extends WorkerThread {
    private SimplePool pool;
    private ThreadDispatchQueue threadQueue;
    private final NioManager nioManager;

    public SimpleThread(SimplePool pool) throws IOException {
        super(pool.group, pool.name);
        this.pool = pool;
        this.nioManager = new NioManager();
        this.threadQueue = new ThreadDispatchQueue(pool.globalQueue, this);
    }

    public ThreadDispatchQueue getDispatchQueue() {
        return this.threadQueue;
    }

    public void unpark() {
        this.nioManager.wakeupIfSelecting();
    }

    public NioManager getNioManager() {
        return this.nioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.debug("run start", new Object[0]);
        try {
            ConcurrentLinkedQueue<Task> sharedQueue = this.pool.tasks;
            while (!this.pool.shutdown) {
                Task task = this.threadQueue.poll();
                if (task == null && (task = (Task)sharedQueue.poll()) == null) {
                    task = (Task)_LinkedList.poll(this.threadQueue.getSourceQueue());
                }
                if (task == null) {
                    this.pool.park(this);
                    continue;
                }
                task.run();
            }
        }
        finally {
            this.debug("run end", new Object[0]);
        }
    }

    protected void debug(String str, Object[] args) {
    }
}

