/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;

public class RuntimeTools {
    public static final String CONCURRENT_PREFIX;
    static /* synthetic */ Class class$edu$emory$mathcs$backport$java$util$concurrent$ConcurrentMap;

    public static byte[] readResourceToByteArray(Class loader, String resourceName) throws MissingResourceException {
        return RuntimeTools.readAndClose(loader.getResourceAsStream(resourceName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAndClose(InputStream inputStream) {
        byte[] byArray;
        if (inputStream == null) {
            return null;
        }
        try {
            int count;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((count = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
            }
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        inputStream.close();
        return byArray;
    }

    public static byte[] getBytecode(Class target) {
        if (target.isPrimitive() || target.isArray()) {
            return null;
        }
        String targetName = target.getName();
        int index = targetName.lastIndexOf(46);
        String simpleName = index < 0 ? targetName : targetName.substring(index + 1);
        return RuntimeTools.readResourceToByteArray(target, simpleName + ".class");
    }

    public static String getDisplayClassName(String internalName) {
        return internalName.replace('/', '.');
    }

    public static String getPrefix(String name, Class type) {
        return type.getName().endsWith(name) ? type.getName().substring(0, type.getName().length() - name.length()) : null;
    }

    static {
        Class<?> clazz = class$edu$emory$mathcs$backport$java$util$concurrent$ConcurrentMap;
        if (clazz == null) {
            clazz = class$edu$emory$mathcs$backport$java$util$concurrent$ConcurrentMap = new ConcurrentMap[0].getClass().getComponentType();
        }
        CONCURRENT_PREFIX = RuntimeTools.getPrefix("java.util.concurrent.ConcurrentMap", clazz);
    }
}

