/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.codec;

import java.io.IOException;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtdispatch.transport.AbstractProtocolCodec;
import org.fusesource.hawtdispatch.util.BufferPools;
import org.fusesource.mqtt.codec.MQTTFrame;

public class MQTTProtocolCodec
extends AbstractProtocolCodec {
    private static final BufferPools BUFFER_POOLS = new BufferPools();
    private int maxMessageLength = 0x6400000;
    private final AbstractProtocolCodec.Action readHeader = new AbstractProtocolCodec.Action(){

        public MQTTFrame apply() throws IOException {
            int length = MQTTProtocolCodec.this.readLength();
            if (length >= 0) {
                if (length > MQTTProtocolCodec.this.maxMessageLength) {
                    throw new IOException("The maximum message length was exceeded");
                }
                byte header = MQTTProtocolCodec.this.readBuffer.get(MQTTProtocolCodec.this.readStart);
                MQTTProtocolCodec.this.readStart = MQTTProtocolCodec.this.readEnd;
                if (length > 0) {
                    MQTTProtocolCodec.this.nextDecodeAction = MQTTProtocolCodec.this.readBody(header, length);
                } else {
                    return new MQTTFrame().header(header);
                }
            }
            return null;
        }

        public /* synthetic */ Object apply() throws IOException {
            return this.apply();
        }
    };

    public MQTTProtocolCodec() {
        this.bufferPools = BUFFER_POOLS;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    protected void encode(Object value) throws IOException {
        Buffer buffer;
        int i$;
        MQTTFrame frame = (MQTTFrame)value;
        this.nextWriteBuffer.write(frame.header());
        int remaining = 0;
        Buffer[] arr$ = frame.buffers;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            buffer = arr$[i$];
            remaining += buffer.length;
        }
        do {
            byte digit = (byte)(remaining & 0x7F);
            if ((remaining >>>= 7) > 0) {
                digit = (byte)(digit | 0x80);
            }
            this.nextWriteBuffer.write(digit);
        } while (remaining > 0);
        arr$ = frame.buffers;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            buffer = arr$[i$];
            this.nextWriteBuffer.write(buffer.data, buffer.offset, buffer.length);
        }
    }

    protected AbstractProtocolCodec.Action initialDecodeAction() {
        return this.readHeader;
    }

    private int readLength() throws IOException {
        this.readEnd = this.readStart + 2;
        int limit = this.readBuffer.position();
        int length = 0;
        int multiplier = 1;
        while (this.readEnd - 1 < limit) {
            byte digit = this.readBuffer.get(this.readEnd - 1);
            length += (digit & 0x7F) * multiplier;
            if ((digit & 0x80) == 0) {
                return length;
            }
            multiplier <<= 7;
            ++this.readEnd;
        }
        return -1;
    }

    AbstractProtocolCodec.Action readBody(final byte header, final int length) {
        return new AbstractProtocolCodec.Action(){

            public MQTTFrame apply() throws IOException {
                int limit = MQTTProtocolCodec.this.readBuffer.position();
                if (limit - MQTTProtocolCodec.this.readStart < length) {
                    MQTTProtocolCodec.this.readEnd = limit;
                    return null;
                }
                Buffer body = new Buffer(MQTTProtocolCodec.this.readBuffer.array(), MQTTProtocolCodec.this.readStart, length);
                MQTTProtocolCodec.this.readEnd = (MQTTProtocolCodec.this.readStart = MQTTProtocolCodec.this.readStart + length);
                MQTTProtocolCodec.this.nextDecodeAction = MQTTProtocolCodec.this.readHeader;
                return new MQTTFrame(body).header(header);
            }

            public /* synthetic */ Object apply() throws IOException {
                return this.apply();
            }
        };
    }
}

