/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.runtime.asm;

import net.sf.retrotranslator.runtime.asm.AnnotationVisitor;
import net.sf.retrotranslator.runtime.asm.AnnotationWriter;
import net.sf.retrotranslator.runtime.asm.Attribute;
import net.sf.retrotranslator.runtime.asm.ByteVector;
import net.sf.retrotranslator.runtime.asm.ClassWriter;
import net.sf.retrotranslator.runtime.asm.FieldVisitor;

final class FieldWriter
implements FieldVisitor {
    FieldWriter next;
    private ClassWriter cw;
    private int access;
    private int name;
    private int desc;
    private int signature;
    private int value;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private Attribute attrs;

    protected FieldWriter(ClassWriter cw, int access, String name, String desc, String signature, Object value) {
        if (cw.firstField == null) {
            cw.firstField = this;
        } else {
            cw.lastField.next = this;
        }
        cw.lastField = this;
        this.cw = cw;
        this.access = access;
        this.name = cw.newUTF8(name);
        this.desc = cw.newUTF8(desc);
        if (signature != null) {
            this.signature = cw.newUTF8(signature);
        }
        if (value != null) {
            this.value = cw.newConstItem((Object)value).index;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        ByteVector bv = new ByteVector();
        bv.putShort(this.cw.newUTF8(desc)).putShort(0);
        AnnotationWriter aw = new AnnotationWriter(this.cw, true, bv, bv, 2);
        if (visible) {
            aw.next = this.anns;
            this.anns = aw;
        } else {
            aw.next = this.ianns;
            this.ianns = aw;
        }
        return aw;
    }

    public void visitAttribute(Attribute attr) {
        attr.next = this.attrs;
        this.attrs = attr;
    }

    public void visitEnd() {
    }
}

