/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.mqtt.cli;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.sf.retrotranslator.runtime.java.lang._Thread;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listener {
    private final MQTT mqtt = new MQTT();
    private final ArrayList<Topic> topics = new ArrayList();
    private boolean debug;
    private boolean showTopic;

    private static void displayHelpAndExit(int exitCode) {
        Listener.stdout("");
        Listener.stdout("This is a simple mqtt client that will subscribe to topics and print all messages it receives.");
        Listener.stdout("");
        Listener.stdout("Arguments: [-h host] [-k keepalive] [-c] [-i id] [-u username [-p password]]");
        Listener.stdout("           [--will-topic topic [--will-payload payload] [--will-qos qos] [--will-retain]]");
        Listener.stdout("           [-d] [-s]");
        Listener.stdout("           ( [-q qos] -t topic )+");
        Listener.stdout("");
        Listener.stdout("");
        Listener.stdout(" -h : mqtt host uri to connect to. Defaults to tcp://localhost:1883.");
        Listener.stdout(" -k : keep alive in seconds for this client. Defaults to 60.");
        Listener.stdout(" -c : disable 'clean session' (store subscription and pending messages when client disconnects).");
        Listener.stdout(" -i : id to use for this client. Defaults to a random id.");
        Listener.stdout(" -u : provide a username (requires MQTT 3.1 broker)");
        Listener.stdout(" -p : provide a password (requires MQTT 3.1 broker)");
        Listener.stdout(" --will-topic : the topic on which to publish the client Will.");
        Listener.stdout(" --will-payload : payload for the client Will, which is sent by the broker in case of");
        Listener.stdout("                  unexpected disconnection. If not given and will-topic is set, a zero");
        Listener.stdout("                  length message will be sent.");
        Listener.stdout(" --will-qos : QoS level for the client Will.");
        Listener.stdout(" --will-retain : if given, make the client Will retained.");
        Listener.stdout(" -d : dispaly debug info on stderr");
        Listener.stdout(" -s : show message topics in output");
        Listener.stdout(" -q : quality of service level to use for the subscription. Defaults to 0.");
        Listener.stdout(" -t : mqtt topic to subscribe to. May be repeated multiple times.");
        Listener.stdout("");
        System.exit(exitCode);
    }

    private static void stdout(Object x) {
        System.out.println(x);
    }

    private static void stderr(Object x) {
        System.err.println(x);
    }

    private static String shift(LinkedList<String> argl) {
        if (argl.isEmpty()) {
            Listener.stderr("Invalid usage: Missing argument");
            Listener.displayHelpAndExit(1);
        }
        return argl.removeFirst();
    }

    public static void main(String[] stringArray) throws Exception {
        Listener listener = new Listener();
        QoS qoS = QoS.AT_MOST_ONCE;
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        while (!linkedList.isEmpty()) {
            try {
                int n;
                String string = linkedList.removeFirst();
                if ("--help".equals(string)) {
                    Listener.displayHelpAndExit(0);
                    continue;
                }
                if ("-h".equals(string)) {
                    listener.mqtt.setHost(Listener.shift(linkedList));
                    continue;
                }
                if ("-k".equals(string)) {
                    listener.mqtt.setKeepAlive(Short.parseShort(Listener.shift(linkedList)));
                    continue;
                }
                if ("-c".equals(string)) {
                    listener.mqtt.setCleanSession(false);
                    continue;
                }
                if ("-i".equals(string)) {
                    listener.mqtt.setClientId(Listener.shift(linkedList));
                    continue;
                }
                if ("-u".equals(string)) {
                    listener.mqtt.setUserName(Listener.shift(linkedList));
                    continue;
                }
                if ("-p".equals(string)) {
                    listener.mqtt.setPassword(Listener.shift(linkedList));
                    continue;
                }
                if ("--will-topic".equals(string)) {
                    listener.mqtt.setWillTopic(Listener.shift(linkedList));
                    continue;
                }
                if ("--will-payload".equals(string)) {
                    listener.mqtt.setWillMessage(Listener.shift(linkedList));
                    continue;
                }
                if ("--will-qos".equals(string)) {
                    n = Integer.parseInt(Listener.shift(linkedList));
                    if (n > QoS.values().length) {
                        Listener.stderr(new StringBuffer().append("Invalid qos value : ").append(n).toString());
                        Listener.displayHelpAndExit(1);
                    }
                    listener.mqtt.setWillQos(QoS.values()[n]);
                    continue;
                }
                if ("--will-retain".equals(string)) {
                    listener.mqtt.setWillRetain(true);
                    continue;
                }
                if ("-d".equals(string)) {
                    listener.debug = true;
                    continue;
                }
                if ("-s".equals(string)) {
                    listener.showTopic = true;
                    continue;
                }
                if ("-q".equals(string)) {
                    n = Integer.parseInt(Listener.shift(linkedList));
                    if (n > QoS.values().length) {
                        Listener.stderr(new StringBuffer().append("Invalid qos value : ").append(n).toString());
                        Listener.displayHelpAndExit(1);
                    }
                    qoS = QoS.values()[n];
                    continue;
                }
                if ("-t".equals(string)) {
                    listener.topics.add(new Topic(Listener.shift(linkedList), qoS));
                    continue;
                }
                Listener.stderr(new StringBuffer().append("Invalid usage: unknown option: ").append(string).toString());
                Listener.displayHelpAndExit(1);
            }
            catch (NumberFormatException numberFormatException) {
                Listener.stderr("Invalid usage: argument not a number");
                Listener.displayHelpAndExit(1);
            }
        }
        if (listener.topics.isEmpty()) {
            Listener.stderr("Invalid usage: no topics specified.");
            Listener.displayHelpAndExit(1);
        }
        listener.execute();
        System.exit(0);
    }

    private void execute() {
        final CallbackConnection connection = this.mqtt.callbackConnection();
        final CountDownLatch done = new CountDownLatch(1);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    this.setName("MQTT client shutdown");
                    if (Listener.this.debug) {
                        Listener.stderr("Disconnecting the client.");
                    }
                    connection.getDispatchQueue().execute(new Runnable(){

                        public void run() {
                            connection.disconnect(new Callback<Void>(){

                                @Override
                                public void onSuccess(Void value) {
                                    done.countDown();
                                }

                                @Override
                                public void onFailure(Throwable value) {
                                    done.countDown();
                                }

                                @Override
                                public /* synthetic */ void onSuccess(Object x0) {
                                    this.onSuccess((Void)x0);
                                }
                            });
                        }
                    });
                    return;
                }
                catch (Throwable throwable) {
                    _Thread.handleUncaughtException(throwable);
                    return;
                }
            }
        });
        connection.listener(new org.fusesource.mqtt.client.Listener(){

            public void onConnected() {
                if (Listener.this.debug) {
                    Listener.stderr("Connected");
                }
            }

            public void onDisconnected() {
                if (Listener.this.debug) {
                    Listener.stderr("Disconnected");
                }
            }

            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
                try {
                    if (Listener.this.showTopic) {
                        Listener.stdout("");
                        Listener.stdout("Topic: " + topic);
                        body.writeTo(System.out);
                        Listener.stdout("");
                    } else {
                        body.writeTo(System.out);
                    }
                    ack.run();
                }
                catch (IOException e) {
                    this.onFailure(e);
                }
            }

            public void onFailure(Throwable value) {
                if (Listener.this.debug) {
                    value.printStackTrace();
                } else {
                    Listener.stderr(value);
                }
                System.exit(2);
            }
        });
        connection.resume();
        connection.connect(new Callback<Void>(){

            @Override
            public void onFailure(Throwable value) {
                if (Listener.this.debug) {
                    value.printStackTrace();
                } else {
                    Listener.stderr(value);
                }
                System.exit(2);
            }

            @Override
            public void onSuccess(Void value) {
                final Topic[] ta = Listener.this.topics.toArray(new Topic[Listener.this.topics.size()]);
                connection.subscribe(ta, new Callback<byte[]>(){

                    @Override
                    public void onSuccess(byte[] value) {
                        if (Listener.this.debug) {
                            for (int i = 0; i < value.length; ++i) {
                                Listener.stderr(new StringBuffer().append("Subscribed to Topic: ").append(ta[i].name()).append(" with QoS: ").append(QoS.values()[value[i]]).toString());
                            }
                        }
                    }

                    @Override
                    public void onFailure(Throwable value) {
                        Listener.stderr(new StringBuffer().append("Subscribe failed: ").append(value).toString());
                        if (Listener.this.debug) {
                            value.printStackTrace();
                        }
                        System.exit(2);
                    }

                    @Override
                    public /* synthetic */ void onSuccess(Object x0) {
                        this.onSuccess((byte[])x0);
                    }
                });
            }

            @Override
            public /* synthetic */ void onSuccess(Object x0) {
                this.onSuccess((Void)x0);
            }
        });
        try {
            done.await();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

