/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.helpers.FIFOWaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.WaitQueue;
import edu.emory.mathcs.backport.java.util.concurrent.locks.CondVar;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.FIFOCondVar;
import java.io.Serializable;

public class ReentrantLock
implements CondVar.ExclusiveLock,
Serializable {
    private final Sync sync;

    public ReentrantLock() {
        this.sync = new NonfairSync();
    }

    public ReentrantLock(boolean fair) {
        this.sync = fair ? new FairSync() : new NonfairSync();
    }

    public void lock() {
        this.sync.lock();
    }

    public boolean tryLock() {
        return this.sync.tryLock();
    }

    public void unlock() {
        this.sync.unlock();
    }

    public Condition newCondition() {
        return this.isFair() ? new FIFOCondVar(this) : new CondVar(this);
    }

    public boolean isHeldByCurrentThread() {
        return this.sync.isHeldByCurrentThread();
    }

    public final boolean isFair() {
        return this.sync.isFair();
    }

    protected Thread getOwner() {
        return this.sync.getOwner();
    }

    public String toString() {
        Thread o = this.getOwner();
        return super.toString() + (o == null ? "[Unlocked]" : "[Locked by thread " + o.getName() + "]");
    }

    static final class FairSync
    extends Sync
    implements WaitQueue.QueuedSync {
        private transient WaitQueue wq_ = new FIFOWaitQueue();

        FairSync() {
        }

        public synchronized boolean recheck(WaitQueue.WaitNode node) {
            Thread caller = Thread.currentThread();
            if (this.owner_ == null) {
                this.owner_ = caller;
                this.holds_ = 1;
                return true;
            }
            if (caller == this.owner_) {
                this.incHolds();
                return true;
            }
            this.wq_.insert(node);
            return false;
        }

        public synchronized void takeOver(WaitQueue.WaitNode node) {
            this.owner_ = node.getOwner();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            Thread caller = Thread.currentThread();
            FairSync fairSync = this;
            synchronized (fairSync) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                if (caller == this.owner_) {
                    this.incHolds();
                    return;
                }
            }
            WaitQueue.WaitNode n = new WaitQueue.WaitNode();
            n.doWaitUninterruptibly(this);
        }

        protected synchronized WaitQueue.WaitNode getSignallee(Thread caller) {
            if (caller != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (this.holds_ >= 2) {
                --this.holds_;
                return null;
            }
            WaitQueue.WaitNode w = this.wq_.extract();
            if (w == null) {
                this.owner_ = null;
                this.holds_ = 0;
            }
            return w;
        }

        public void unlock() {
            WaitQueue.WaitNode w;
            Thread caller = Thread.currentThread();
            do {
                if ((w = this.getSignallee(caller)) != null) continue;
                return;
            } while (!w.signal(this));
        }

        public final boolean isFair() {
            return true;
        }
    }

    static final class NonfairSync
    extends Sync {
        NonfairSync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lock() {
            Thread caller = Thread.currentThread();
            NonfairSync nonfairSync = this;
            synchronized (nonfairSync) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                if (caller == this.owner_) {
                    this.incHolds();
                    return;
                }
                boolean wasInterrupted = Thread.interrupted();
                try {
                    do {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            wasInterrupted = true;
                        }
                    } while (this.owner_ != null);
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return;
                }
                finally {
                    if (wasInterrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public synchronized void unlock() {
            if (Thread.currentThread() != this.owner_) {
                throw new IllegalMonitorStateException("Not owner");
            }
            if (--this.holds_ == 0) {
                this.owner_ = null;
                this.notify();
            }
        }

        public final boolean isFair() {
            return false;
        }
    }

    static abstract class Sync
    implements Serializable {
        protected transient Thread owner_ = null;
        protected transient int holds_ = 0;

        protected Sync() {
        }

        public abstract void lock();

        final void incHolds() {
            int nextHolds;
            if ((nextHolds = ++this.holds_) < 0) {
                throw new Error("Maximum lock count exceeded");
            }
            this.holds_ = nextHolds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean tryLock() {
            Thread caller = Thread.currentThread();
            Sync sync = this;
            synchronized (sync) {
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1;
                    return true;
                }
                if (caller == this.owner_) {
                    this.incHolds();
                    return true;
                }
            }
            return false;
        }

        public abstract void unlock();

        public synchronized boolean isHeldByCurrentThread() {
            return this.holds_ > 0 && Thread.currentThread() == this.owner_;
        }

        public abstract boolean isFair();

        protected synchronized Thread getOwner() {
            return this.owner_;
        }
    }
}

