/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

public class CountDownLatch {
    private int count_;

    public CountDownLatch(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        this.count_ = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        CountDownLatch countDownLatch = this;
        synchronized (countDownLatch) {
            while (this.count_ > 0) {
                this.wait();
            }
        }
    }

    public synchronized void countDown() {
        if (this.count_ == 0) {
            return;
        }
        if (--this.count_ == 0) {
            this.notifyAll();
        }
    }

    public long getCount() {
        return this.count_;
    }

    public String toString() {
        return super.toString() + "[Count = " + this.getCount() + "]";
    }
}

