/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.service;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.fusesource.insight.log.service.LogQuery;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQueryActivator
implements BundleActivator {
    private static final transient Logger LOG = LoggerFactory.getLogger(LogQueryActivator.class);
    private BundleContext bundleContext;
    private MBeanServer mbeanServer;
    private LogQuery logQuery;

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        this.mbeanServer = this.lookupMBeanServer();
        this.logQuery = new LogQuery();
        this.logQuery.setBundleContext(bundleContext);
        this.logQuery.registerMBeanServer(this.mbeanServer);
        this.logQuery.init();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.logQuery != null) {
            if (this.mbeanServer != null) {
                this.logQuery.unregisterMBeanServer(this.mbeanServer);
            }
            this.logQuery.destroy();
        }
    }

    protected MBeanServer lookupMBeanServer() {
        ServiceReference ref = this.bundleContext.getServiceReference(MBeanServer.class.getName());
        if (ref != null) {
            return (MBeanServer)this.bundleContext.getService(ref);
        }
        LOG.warn("Could not find MBeanServer in the OSGi registry so using the platform MBeanServer instead");
        return ManagementFactory.getPlatformMBeanServer();
    }
}

