/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.support;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.codehaus.jackson.map.ObjectMapper;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.LogResults;
import org.fusesource.insight.log.support.LogQuerySupportMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogQuerySupport
implements LogQuerySupportMBean {
    private static final transient Logger LOG = LoggerFactory.getLogger(LogQuerySupport.class);
    protected ObjectMapper mapper = new ObjectMapper();
    private ObjectName mbeanName;
    private MBeanServer mbeanServer;
    private String hostName;

    protected LogQuerySupport() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.warn("Failed to get host name: " + e, (Throwable)e);
        }
    }

    public void start() {
        MBeanServer server = this.getMbeanServer();
        if (server != null) {
            this.registerMBeanServer(server);
        } else {
            LOG.error("No MBeanServer available so cannot register mbean");
        }
    }

    public void stop() {
        MBeanServer server = this.getMbeanServer();
        if (server != null) {
            this.unregisterMBeanServer(server);
        }
    }

    @Override
    public LogResults allLogResults() throws IOException {
        return this.getLogResults(-1);
    }

    @Override
    public LogResults logResultsSince(long time) throws IOException {
        LogFilter filter = new LogFilter();
        filter.setAfterTimestamp(time);
        return this.queryLogResults(filter);
    }

    @Override
    public String getLogEvents(int maxCount) throws IOException {
        LogResults results = this.getLogResults(maxCount);
        return this.toJSON(results);
    }

    @Override
    public String filterLogEvents(String jsonFilter) throws IOException {
        LogResults results = this.jsonQueryLogResults(jsonFilter);
        return this.toJSON(results);
    }

    @Override
    public LogResults jsonQueryLogResults(String jsonFilter) throws IOException {
        LogFilter filter = this.jsonToLogFilter(jsonFilter);
        return this.queryLogResults(filter);
    }

    public ObjectName getMbeanName() throws MalformedObjectNameException {
        if (this.mbeanName == null) {
            this.mbeanName = new ObjectName("org.fusesource.insight:type=LogQuery");
        }
        return this.mbeanName;
    }

    public void setMbeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    public MBeanServer getMbeanServer() {
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getMbeanName();
            ObjectInstance objectInstance = mbeanServer.registerMBean(this, name);
        }
        catch (Exception e) {
            LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(this.getMbeanName());
            }
            catch (Exception e) {
                LOG.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    protected String toJSON(Object answer) throws IOException {
        try {
            StringWriter writer = new StringWriter();
            this.mapper.writeValue((Writer)writer, answer);
            return writer.toString();
        }
        catch (IOException e) {
            LOG.warn("Failed to marshal the events: " + e, (Throwable)e);
            throw new IOException(e.getMessage());
        }
    }

    protected LogFilter jsonToLogFilter(String json) throws IOException {
        if (json == null) {
            return null;
        }
        if ((json = json.trim()).length() == 0 || json.equals("{}")) {
            return null;
        }
        return (LogFilter)this.mapper.reader(LogFilter.class).readValue(json);
    }
}

