/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fusesource.insight.log.LogEvent;
import org.fusesource.insight.log.LogFilter;
import org.fusesource.insight.log.support.Predicate;
import org.fusesource.insight.log.support.Strings;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.ops4j.pax.logging.spi.PaxLocationInfo;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class Logs {
    public static LogEvent newInstance(PaxLoggingEvent event) {
        PaxLocationInfo locationInformation;
        LogEvent answer = new LogEvent();
        answer.setLevel(Logs.toString(event.getLevel()));
        answer.setMessage(event.getMessage());
        answer.setLogger(event.getLoggerName());
        answer.setTimestamp(new Date(event.getTimeStamp()));
        answer.setThread(event.getThreadName());
        answer.setException(event.getThrowableStrRep());
        Map eventProperties = event.getProperties();
        if (eventProperties != null && eventProperties.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            Set set = eventProperties.entrySet();
            for (Map.Entry entry : set) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null) continue;
                properties.put(Logs.toString(key), Logs.toString(value));
            }
            answer.setProperties(properties);
        }
        if ((locationInformation = event.getLocationInformation()) != null) {
            answer.setClassName(locationInformation.getClassName());
            answer.setFileName(locationInformation.getFileName());
            answer.setMethodName(locationInformation.getMethodName());
            answer.setLineNumber(locationInformation.getLineNumber());
        }
        return answer;
    }

    protected static String toString(Object value) {
        return value.toString();
    }

    public static Predicate<PaxLoggingEvent> createPredicate(LogFilter filter) {
        String matchesText;
        Long after;
        Long before;
        if (filter == null) {
            return null;
        }
        final ArrayList<Predicate<PaxLoggingEvent>> predicates = new ArrayList<Predicate<PaxLoggingEvent>>();
        final Set<String> levels = filter.getLevelsSet();
        if (levels.size() > 0) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    PaxLevel level = event.getLevel();
                    return level != null && levels.contains(level.toString());
                }
            });
        }
        if ((before = filter.getBeforeTimestamp()) != null) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    long time = event.getTimeStamp();
                    return time < before;
                }
            });
        }
        if ((after = filter.getAfterTimestamp()) != null) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    long time = event.getTimeStamp();
                    return time > after;
                }
            });
        }
        if ((matchesText = filter.getMatchesText()) != null && matchesText.length() > 0) {
            predicates.add(new Predicate<PaxLoggingEvent>(){

                @Override
                public boolean matches(PaxLoggingEvent event) {
                    if (Strings.contains(matchesText, event.getFQNOfLoggerClass(), event.getMessage(), event.getLoggerName(), event.getThreadName())) {
                        return true;
                    }
                    String[] throwableStrRep = event.getThrowableStrRep();
                    if (throwableStrRep != null && Strings.contains(matchesText, throwableStrRep)) {
                        return true;
                    }
                    Map properties = event.getProperties();
                    return properties != null && Strings.contains(matchesText, properties.toString());
                }
            });
        }
        if (predicates.size() == 0) {
            return null;
        }
        if (predicates.size() == 1) {
            return (Predicate)predicates.get(0);
        }
        return new Predicate<PaxLoggingEvent>(){

            public String toString() {
                return "AndPredicate" + predicates;
            }

            @Override
            public boolean matches(PaxLoggingEvent event) {
                for (Predicate predicate : predicates) {
                    if (predicate.matches(event)) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

