/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.graph.support;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.util.BaseOutputWriter;
import com.googlecode.jmxtrans.util.LifecycleException;
import com.googlecode.jmxtrans.util.ValidationException;
import java.util.Map;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.fusesource.insight.graph.JmxCollector;
import org.fusesource.insight.graph.support.JsonUnmarshaller;
import org.fusesource.insight.graph.support.PropertiesObjectWriterUnmarshaller;
import org.fusesource.insight.graph.support.Unmarshaller;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.ZKData;
import org.linkedin.zookeeper.tracker.TrackedNode;
import org.linkedin.zookeeper.tracker.ZKDataReader;
import org.linkedin.zookeeper.tracker.ZooKeeperTreeTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKClusterOutputWriter
extends BaseOutputWriter
implements OutputWriter {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZKClusterOutputWriter.class);
    private final JmxCollector collector;
    private final ZooKeeperTreeTracker<OutputWriter> tracker;
    private Map<String, KeyedObjectPool> objectPool;

    public ZKClusterOutputWriter(JmxCollector collector, String zkPath) {
        this.collector = collector;
        ZKDataReader<OutputWriter> reader = new ZKDataReader<OutputWriter>(){

            public ZKData<OutputWriter> readData(IZKClient zkClient, String path, Watcher watcher) throws InterruptedException, KeeperException {
                Stat stat = new Stat();
                Unmarshaller<OutputWriter> unmarshaller = null;
                if (path.endsWith(".json")) {
                    unmarshaller = new JsonUnmarshaller<OutputWriter>(OutputWriter.class);
                } else if (path.endsWith(".properties")) {
                    unmarshaller = new PropertiesObjectWriterUnmarshaller();
                } else {
                    LOG.debug("Ignoring ZK Path: " + path + " as it doesn't end in .json");
                    return new ZKData(null, stat);
                }
                LOG.info("Reading ZK path: " + path + " and converting to an OutputWriter");
                byte[] data = zkClient.getData(path, watcher, stat);
                try {
                    OutputWriter outputWriter = unmarshaller.unmarshal(path, data);
                    if (outputWriter != null) {
                        ZKClusterOutputWriter.this.configureWriter(outputWriter);
                        outputWriter.start();
                    }
                    return new ZKData((Object)outputWriter, stat);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public boolean isEqual(OutputWriter o1, OutputWriter o2) {
                return o1 == o2 || o1 != null && o1.equals(o2);
            }
        };
        this.tracker = new ZooKeeperTreeTracker((IZKClient)collector.getZkClient(), (ZKDataReader)reader, zkPath);
    }

    @Override
    public void start() throws LifecycleException {
        super.start();
        try {
            this.tracker.track();
        }
        catch (Exception e) {
            throw new LifecycleException(e.getMessage(), e);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.tracker.destroy();
        super.stop();
    }

    @Override
    public void validateSetup(Query query) throws ValidationException {
        Map tree = this.tracker.getTree();
        for (Map.Entry entry : tree.entrySet()) {
            String name = (String)entry.getKey();
            TrackedNode value = (TrackedNode)entry.getValue();
            OutputWriter data = (OutputWriter)value.getData();
            if (data == null) continue;
            this.configureWriter(data);
            data.validateSetup(query);
        }
    }

    protected void configureWriter(OutputWriter data) {
        if (this.objectPool != null) {
            data.setObjectPoolMap(this.objectPool);
        }
    }

    @Override
    public void doWrite(Query query) throws Exception {
        Map tree = this.tracker.getTree();
        for (Map.Entry entry : tree.entrySet()) {
            String name = (String)entry.getKey();
            TrackedNode value = (TrackedNode)entry.getValue();
            OutputWriter data = (OutputWriter)value.getData();
            if (data == null) continue;
            this.configureWriter(data);
            data.doWrite(query);
        }
    }

    @Override
    public void setObjectPoolMap(Map<String, KeyedObjectPool> objectPool) {
        this.objectPool = objectPool;
    }
}

