/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.graph.es;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.util.BaseOutputWriter;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.LifecycleException;
import com.googlecode.jmxtrans.util.ValidationException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.node.Node;
import org.fusesource.insight.graph.es.ElasticSender;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ElasticSearchOutputWriter
extends BaseOutputWriter
implements OutputWriter,
ServiceTrackerCustomizer<Node, Node> {
    private static final AtomicLong SEQUENCE_COUNTER = new AtomicLong(System.currentTimeMillis() * 1000L);
    private BundleContext bundleContext;
    private ServiceTracker<Node, Node> tracker;
    private String index;
    private String type;
    private ElasticSender sender;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public ElasticSearchOutputWriter() {
        this.sender = new ElasticSender();
        this.bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        this.tracker = new ServiceTracker(this.bundleContext, Node.class, (ServiceTrackerCustomizer)this);
    }

    @Override
    public void start() throws LifecycleException {
        this.index = this.getStringSetting("index", "insight");
        this.type = this.getStringSetting("type", "sta");
        this.tracker.open();
    }

    @Override
    public void stop() throws LifecycleException {
        this.tracker.close();
    }

    public Node addingService(ServiceReference<Node> nodeServiceReference) {
        Node node = (Node)this.bundleContext.getService(nodeServiceReference);
        this.sender.setNode(node);
        CreateIndexRequest request = new CreateIndexRequest(this.index);
        HashMap properties = new HashMap();
        HashMap<String, String> seq = new HashMap<String, String>();
        seq.put("type", "string");
        seq.put("index", "not_analyzed");
        properties.put("seq", seq);
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("type", "double");
        properties.put("value", value);
        HashMap options = new HashMap();
        options.put("properties", properties);
        request.mapping(this.type, options);
        this.sender.createIndexIfNeeded(request);
        this.sender.init();
        return node;
    }

    public void modifiedService(ServiceReference<Node> nodeServiceReference, Node node) {
    }

    public void removedService(ServiceReference<Node> nodeServiceReference, Node node) {
        this.sender.destroy();
        this.bundleContext.ungetService(nodeServiceReference);
    }

    @Override
    public void validateSetup(Query query) throws ValidationException {
    }

    @Override
    public void doWrite(Query query) throws Exception {
        for (Result result : query.getResults()) {
            Map<String, Object> resultValues = result.getValues();
            if (resultValues == null) continue;
            for (Map.Entry<String, Object> values : resultValues.entrySet()) {
                if (!JmxUtils.isNumeric(values.getValue())) continue;
                StringBuilder writer = new StringBuilder();
                writer.append("{ \"host\": ");
                ElasticSender.quote(query.getServer().getAlias(), writer);
                writer.append(", \"seq\" : " + SEQUENCE_COUNTER.incrementAndGet());
                writer.append(", \"timestamp\" : ");
                ElasticSender.quote(this.formatDate(result.getEpoch()), writer);
                writer.append(", \"object\" : ");
                ElasticSender.quote(query.getObj(), writer);
                writer.append(", \"attribute\" : ");
                ElasticSender.quote(result.getAttributeName(), writer);
                writer.append(", \"class\" : ");
                ElasticSender.quote(result.getClassName(), writer);
                writer.append(", \"alias\" : ");
                ElasticSender.quote(result.getClassNameAlias(), writer);
                writer.append(", \"type\" : ");
                ElasticSender.quote(result.getTypeName(), writer);
                writer.append(", \"key\" : ");
                ElasticSender.quote(values.getKey(), writer);
                writer.append(", \"value\" : " + values.getValue().toString());
                writer.append(" }");
                IndexRequest request = new IndexRequest().index(this.index).type(this.type).source(writer.toString()).create(true);
                this.sender.put(request);
            }
        }
    }

    private String formatDate(long timestamp) {
        return this.simpleDateFormat.format(new Date(timestamp));
    }

    public String getStringSetting(String key, String defaultVal) {
        Object value = this.getSettings().get(key);
        return value != null ? value.toString() : defaultVal;
    }
}

