/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.graph;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.jobs.ServerJob;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.LifecycleException;
import com.googlecode.jmxtrans.util.ValidationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.commons.pool.KeyedObjectPool;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.map.JsonMappingException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.fusesource.insight.graph.support.Json;
import org.fusesource.insight.graph.support.SchedulerFactory;
import org.fusesource.insight.graph.support.ZKClusterOutputWriter;
import org.quartz.CronExpression;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxCollector {
    public static final String GRAPH_JSON = "org.fusesource.insight.graph.json";
    public static int SECONDS_BETWEEN_SERVER_JOB_RUNS = 60;
    public static final String GRAPH_CLUSTER_PREFIX = "graphCluster.";
    private static final transient Logger LOG = LoggerFactory.getLogger(JmxCollector.class);
    protected static final String DEFAULT_GRAPH_CLUSTER_NAME = "default";
    private final FabricService fabricService;
    private List<Server> masterServersList = new ArrayList<Server>();
    private Map<String, KeyedObjectPool> objectPoolMap;
    private Scheduler scheduler;
    private MBeanServer mbeanServer;
    private IZKClient zkClient;
    private String clusterRoot = "/fabric/registry/insight/stats";
    private Map<String, ZKClusterOutputWriter> outputWriters = new HashMap<String, ZKClusterOutputWriter>();

    public JmxCollector(FabricService fabricService) {
        this.fabricService = fabricService;
    }

    public void start() throws IOException, ValidationException, LifecycleException, SchedulerException, ParseException {
        Profile[] profiles;
        Container container = this.fabricService.getCurrentContainer();
        if (container != null && (profiles = container.getProfiles()) != null) {
            for (Profile profile : profiles) {
                this.loadProfile(container, profile);
            }
        }
        this.process();
    }

    public void destroy() throws Exception {
        for (ZKClusterOutputWriter outputWriter : this.outputWriters.values()) {
            if (outputWriter == null) continue;
            outputWriter.stop();
        }
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
    }

    public Scheduler getScheduler() throws SchedulerException {
        if (this.scheduler == null) {
            LOG.warn("No scheduler configured so creating a default implementation");
            this.scheduler = new SchedulerFactory().createScheduler();
        }
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IZKClient getZkClient() {
        return this.zkClient;
    }

    public void setZkClient(IZKClient zkClient) {
        this.zkClient = zkClient;
    }

    public String getClusterRoot() {
        return this.clusterRoot;
    }

    public void setClusterRoot(String clusterRoot) {
        this.clusterRoot = clusterRoot;
    }

    public void process() throws LifecycleException, ValidationException, SchedulerException, ParseException {
        for (Server server : this.masterServersList) {
            if (server.isLocal()) {
                server.setLocalMBeanServer(this.mbeanServer);
                server.setAlias(this.fabricService.getCurrentContainerName());
            }
            for (Query query : server.getQueries()) {
                query.setServer(server);
                for (OutputWriter writer : query.getOutputWriters()) {
                    writer.setObjectPoolMap(this.getObjectPoolMap());
                    writer.start();
                }
            }
            this.validateSetup(server.getQueries());
            this.scheduleJob(server);
        }
    }

    private void scheduleJob(Server server) throws SchedulerException, ParseException {
        Scheduler scheduler = this.getScheduler();
        String name = server.getHost() + ":" + server.getPort() + "-" + System.currentTimeMillis();
        JobDetail jd = new JobDetail(name, "ServerJob", ServerJob.class);
        JobDataMap map = new JobDataMap();
        map.put((Object)Server.class.getName(), (Object)server);
        map.put((Object)Server.JMX_CONNECTION_FACTORY_POOL, (Object)this.getObjectPoolMap().get(Server.JMX_CONNECTION_FACTORY_POOL));
        jd.setJobDataMap(map);
        CronTrigger trigger = null;
        if (server.getCronExpression() != null && CronExpression.isValidExpression((String)server.getCronExpression())) {
            trigger = new CronTrigger();
            trigger.setCronExpression(server.getCronExpression());
            trigger.setName(server.getHost() + ":" + server.getPort() + "-" + Long.valueOf(System.currentTimeMillis()).toString());
            trigger.setStartTime(new Date());
        } else {
            Trigger minuteTrigger = TriggerUtils.makeSecondlyTrigger((int)SECONDS_BETWEEN_SERVER_JOB_RUNS);
            minuteTrigger.setName(server.getHost() + ":" + server.getPort() + "-" + Long.valueOf(System.currentTimeMillis()).toString());
            minuteTrigger.setStartTime(new Date());
            trigger = minuteTrigger;
        }
        scheduler.scheduleJob(jd, (Trigger)trigger);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scheduled job: " + jd.getName() + " for server: " + server);
        }
    }

    private void validateSetup(List<Query> queries) throws ValidationException {
        for (Query q : queries) {
            this.validateSetup(q);
        }
    }

    private void validateSetup(Query query) throws ValidationException {
        List<OutputWriter> writers = query.getOutputWriters();
        if (writers != null) {
            for (OutputWriter w : writers) {
                w.validateSetup(query);
            }
        }
    }

    @JsonIgnore
    public Map<String, KeyedObjectPool> getObjectPoolMap() {
        if (this.objectPoolMap == null) {
            this.objectPoolMap = JmxUtils.getDefaultPoolMap();
        }
        return this.objectPoolMap;
    }

    public void setObjectPoolMap(Map<String, KeyedObjectPool> poolMap) {
        this.objectPoolMap = poolMap;
    }

    protected void loadProfile(Container container, Profile profile) throws IOException, LifecycleException {
        JmxProcess process;
        Map fileConfigurations = profile.getFileConfigurations();
        byte[] bytes = (byte[])fileConfigurations.get(GRAPH_JSON);
        if (bytes != null && bytes.length > 0 && (process = JmxCollector.getJmxProcess(GRAPH_JSON, new ByteArrayInputStream(bytes))) != null) {
            List<Server> servers = process.getServers();
            for (Server server : servers) {
                this.configureProfileServer(server, container, profile);
            }
            JmxUtils.mergeServerLists(this.masterServersList, servers);
        }
        for (Profile p : profile.getParents()) {
            this.loadProfile(container, p);
        }
    }

    protected void configureProfileServer(Server server, Container container, Profile profile) throws LifecycleException {
        if (server.isLocal()) {
            server.setLocalMBeanServer(this.mbeanServer);
            String serverAlias = profile.getId() + "." + this.fabricService.getCurrentContainerName();
            server.setAlias(serverAlias);
        }
        List<Query> queries = server.getQueries();
        for (Query query : queries) {
            List<OutputWriter> writers = query.getOutputWriters();
            if (writers == null) {
                writers = new ArrayList<OutputWriter>();
                query.setOutputWriters(writers);
            }
            if (!writers.isEmpty()) continue;
            Map containerProperties = profile.getContainerConfiguration();
            HashSet<String> clusterNames = new HashSet<String>();
            for (Map.Entry entry : containerProperties.entrySet()) {
                String key = (String)entry.getKey();
                String clusterName = (String)entry.getValue();
                if (!key.startsWith(GRAPH_CLUSTER_PREFIX)) continue;
                clusterNames.add(clusterName);
            }
            if (clusterNames.isEmpty()) {
                clusterNames.add(DEFAULT_GRAPH_CLUSTER_NAME);
            }
            for (String clusterName : clusterNames) {
                OutputWriter writer = this.createClusterWriter(clusterName);
                if (writer == null) continue;
                writers.add(writer);
            }
        }
    }

    protected OutputWriter createClusterWriter(String clusterName) throws LifecycleException {
        ZKClusterOutputWriter outputWriter = this.outputWriters.get(clusterName);
        if (outputWriter == null) {
            String zkPath = this.getClusterRoot() + "/" + clusterName;
            outputWriter = new ZKClusterOutputWriter(this, zkPath);
            this.outputWriters.put(clusterName, outputWriter);
            outputWriter.start();
        }
        return outputWriter;
    }

    public static JmxProcess getJmxProcess(String name, InputStream in) throws JsonParseException, JsonMappingException, IOException {
        JmxProcess jmx = Json.readJsonValue(name, in, JmxProcess.class);
        jmx.setName(name);
        return jmx;
    }
}

