/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.util;

import com.googlecode.jmxtrans.OutputWriter;
import com.googlecode.jmxtrans.model.JmxProcess;
import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.DatagramSocketFactory;
import com.googlecode.jmxtrans.util.JmxConnectionFactory;
import com.googlecode.jmxtrans.util.SocketFactory;
import com.googlecode.jmxtrans.util.ValidationException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxUtils {
    private static final Logger log = LoggerFactory.getLogger(JmxUtils.class);

    public static void mergeServerLists(List<Server> existing, List<Server> adding) {
        for (Server server : adding) {
            if (existing.contains(server)) {
                Server found = existing.get(existing.indexOf(server));
                List<Query> queries = server.getQueries();
                for (Query q : queries) {
                    try {
                        found.addQuery(q);
                    }
                    catch (ValidationException ex) {
                        log.error("Error adding query: " + q + " to server" + server, (Throwable)ex);
                    }
                }
                continue;
            }
            existing.add(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processQueriesForServer(MBeanServerConnection mbeanServer, Server server) throws Exception {
        block6: {
            block5: {
                if (!server.isQueriesMultiThreaded()) break block5;
                ExecutorService service = null;
                try {
                    service = Executors.newFixedThreadPool(server.getNumQueryThreads());
                    if (log.isDebugEnabled()) {
                        log.debug("----- Creating " + server.getQueries().size() + " query threads");
                    }
                    ArrayList<Callable<Object>> threads = new ArrayList<Callable<Object>>(server.getQueries().size());
                    for (Query query : server.getQueries()) {
                        query.setServer(server);
                        ProcessQueryThread pqt = new ProcessQueryThread(mbeanServer, query);
                        threads.add(Executors.callable(pqt));
                    }
                    service.invokeAll(threads);
                }
                catch (Throwable throwable) {
                    JmxUtils.shutdownAndAwaitTermination(service);
                    throw throwable;
                }
                JmxUtils.shutdownAndAwaitTermination(service);
                break block6;
            }
            for (Query query : server.getQueries()) {
                query.setServer(server);
                JmxUtils.processQuery(mbeanServer, query);
            }
        }
    }

    private static void shutdownAndAwaitTermination(ExecutorService service) {
        service.shutdown();
        try {
            if (!service.awaitTermination(60L, TimeUnit.SECONDS)) {
                service.shutdownNow();
                if (!service.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.error("Pool did not terminate");
                }
            }
        }
        catch (InterruptedException ie) {
            service.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static void processQuery(MBeanServerConnection mbeanServer, Query query) throws Exception {
        ObjectName oName = new ObjectName(query.getObj());
        Set<ObjectName> queryNames = mbeanServer.queryNames(oName, null);
        for (ObjectName queryName : queryNames) {
            ArrayList<Result> resList = new ArrayList<Result>();
            MBeanInfo info = mbeanServer.getMBeanInfo(queryName);
            ObjectInstance oi = mbeanServer.getObjectInstance(queryName);
            List<String> queryAttributes = query.getAttr();
            if (queryAttributes == null || queryAttributes.size() == 0) {
                MBeanAttributeInfo[] attrs;
                for (MBeanAttributeInfo attrInfo : attrs = info.getAttributes()) {
                    query.addAttr(attrInfo.getName());
                }
            }
            try {
                if (query.getAttr() == null || query.getAttr().size() <= 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Executing queryName: " + queryName.getCanonicalName() + " from query: " + query);
                }
                AttributeList al = mbeanServer.getAttributes(queryName, query.getAttr().toArray(new String[query.getAttr().size()]));
                for (Attribute attribute : al.asList()) {
                    JmxUtils.getResult(resList, info, oi, attribute, query);
                }
                query.setResults(resList);
                JmxUtils.runOutputWritersForQuery(query);
                if (!log.isDebugEnabled()) continue;
                log.debug("Finished running outputWriters for query: " + query);
            }
            catch (UnmarshalException ue) {
                if (ue.getCause() == null || !(ue.getCause() instanceof ClassNotFoundException)) continue;
                log.debug("Bad unmarshall, continuing. This is probably ok and due to something like this: http://ehcache.org/xref/net/sf/ehcache/distribution/RMICacheManagerPeerListener.html#52", (Object)ue.getMessage());
            }
        }
    }

    private static void getResult(List<Result> resList, MBeanInfo info, ObjectInstance oi, String attributeName, CompositeData cds, Query query) {
        CompositeType t = cds.getCompositeType();
        Result r = JmxUtils.getNewResultObject(info, oi, attributeName, query);
        Set<String> keys = t.keySet();
        for (String key : keys) {
            Object value = cds.get(key);
            if (value instanceof TabularDataSupport) {
                TabularDataSupport tds = (TabularDataSupport)value;
                JmxUtils.processTabularDataSupport(resList, info, oi, r, attributeName + "." + key, tds, query);
                r.addValue(key, value);
                continue;
            }
            if (value instanceof CompositeDataSupport) {
                CompositeDataSupport cds2 = (CompositeDataSupport)value;
                JmxUtils.getResult(resList, info, oi, attributeName, cds2, query);
                return;
            }
            r.addValue(key, value);
        }
        resList.add(r);
    }

    private static void processTabularDataSupport(List<Result> resList, MBeanInfo info, ObjectInstance oi, Result r, String attributeName, TabularDataSupport tds, Query query) {
        Set<Map.Entry<Object, Object>> entries = tds.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            Object entryKeys = entry.getKey();
            if (entryKeys instanceof List) {
                StringBuilder sb = new StringBuilder();
                for (Object entryKey : (List)entryKeys) {
                    sb.append(".");
                    sb.append(entryKey);
                }
                String attributeName2 = sb.toString();
                Object entryValue = entry.getValue();
                if (entryValue instanceof CompositeDataSupport) {
                    JmxUtils.getResult(resList, info, oi, attributeName + attributeName2, (CompositeDataSupport)entryValue, query);
                    continue;
                }
                throw new RuntimeException("!!!!!!!!!! Please file a bug: http://code.google.com/p/jmxtrans/issues/entry entryValue is: " + entryValue.getClass().getCanonicalName());
            }
            throw new RuntimeException("!!!!!!!!!! Please file a bug: http://code.google.com/p/jmxtrans/issues/entry entryKeys is: " + entryKeys.getClass().getCanonicalName());
        }
    }

    private static Result getNewResultObject(MBeanInfo info, ObjectInstance oi, String attributeName, Query query) {
        Result r = new Result(attributeName);
        r.setQuery(query);
        r.setClassName(info.getClassName());
        r.setTypeName(oi.getObjectName().getCanonicalKeyPropertyListString());
        return r;
    }

    private static void getResult(List<Result> resList, MBeanInfo info, ObjectInstance oi, Attribute attribute, Query query) {
        Object value = attribute.getValue();
        if (value != null) {
            if (value instanceof CompositeDataSupport) {
                JmxUtils.getResult(resList, info, oi, attribute.getName(), (CompositeData)value, query);
            } else if (value instanceof CompositeData[]) {
                for (CompositeData cd : (CompositeData[])value) {
                    JmxUtils.getResult(resList, info, oi, attribute.getName(), cd, query);
                }
            } else if (value instanceof ObjectName[]) {
                Result r = JmxUtils.getNewResultObject(info, oi, attribute.getName(), query);
                for (ObjectName obj : (ObjectName[])value) {
                    r.addValue(obj.getCanonicalName(), obj.getKeyPropertyListString());
                }
                resList.add(r);
            } else if (value.getClass().isArray()) {
                Result r = JmxUtils.getNewResultObject(info, oi, attribute.getName(), query);
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object val = Array.get(value, i);
                    r.addValue(attribute.getName() + "." + i, val);
                }
                resList.add(r);
            } else if (value instanceof TabularDataSupport) {
                TabularDataSupport tds = (TabularDataSupport)value;
                Result r = JmxUtils.getNewResultObject(info, oi, attribute.getName(), query);
                JmxUtils.processTabularDataSupport(resList, info, oi, r, attribute.getName(), tds, query);
                resList.add(r);
            } else {
                Result r = JmxUtils.getNewResultObject(info, oi, attribute.getName(), query);
                r.addValue(attribute.getName(), value);
                resList.add(r);
            }
        }
    }

    private static void runOutputWritersForQuery(Query query) throws Exception {
        List<OutputWriter> writers = query.getOutputWriters();
        if (writers != null) {
            for (OutputWriter writer : writers) {
                writer.doWrite(query);
            }
        }
    }

    public static JMXConnector getServerConnection(Server server) throws Exception {
        JMXServiceURL url = new JMXServiceURL(server.getUrl());
        if (server.getProtocolProviderPackages() != null && server.getProtocolProviderPackages().contains("weblogic")) {
            return JMXConnectorFactory.connect(url, JmxUtils.getWebLogicEnvironment(server));
        }
        return JMXConnectorFactory.connect(url, JmxUtils.getEnvironment(server));
    }

    public static Map<String, String> getWebLogicEnvironment(Server server) {
        HashMap<String, String> environment = new HashMap<String, String>();
        String username = server.getUsername();
        String password = server.getPassword();
        if (username != null && password != null) {
            environment.put("jmx.remote.protocol.provider.pkgs", server.getProtocolProviderPackages());
            environment.put("java.naming.security.principal", username);
            environment.put("java.naming.security.credentials", password);
        }
        return environment;
    }

    public static Map<String, String[]> getEnvironment(Server server) {
        HashMap<String, String[]> environment = new HashMap<String, String[]>();
        String username = server.getUsername();
        String password = server.getPassword();
        if (username != null && password != null) {
            String[] credentials = new String[]{username, password};
            environment.put("jmx.remote.credentials", credentials);
        }
        return environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(JmxProcess process) throws Exception {
        ArrayList<JMXConnector> conns = new ArrayList<JMXConnector>();
        if (process.isServersMultiThreaded()) {
            ExecutorService service = null;
            try {
                service = Executors.newFixedThreadPool(process.getNumMultiThreadedServers());
                for (Server server : process.getServers()) {
                    if (server.getLocalMBeanServer() != null) {
                        service.execute(new ProcessServerThread(server, null));
                        continue;
                    }
                    JMXConnector conn = JmxUtils.getServerConnection(server);
                    conns.add(conn);
                    service.execute(new ProcessServerThread(server, conn));
                }
                service.shutdown();
            }
            finally {
                try {
                    service.awaitTermination(60000L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ex) {
                    log.error("Error shutting down execution.", (Throwable)ex);
                }
            }
        }
        for (Server server : process.getServers()) {
            if (server.getLocalMBeanServer() != null) {
                JmxUtils.processServer(server, null);
                continue;
            }
            JMXConnector conn = JmxUtils.getServerConnection(server);
            conns.add(conn);
            JmxUtils.processServer(server, conn);
        }
        for (JMXConnector conn : conns) {
            try {
                conn.close();
            }
            catch (Exception ex) {
                log.error("Error closing connection.", (Throwable)ex);
            }
        }
    }

    public static void processServer(Server server, JMXConnector conn) throws Exception {
        if (server.getLocalMBeanServer() != null) {
            JmxUtils.processQueriesForServer(server.getLocalMBeanServer(), server);
        } else {
            MBeanServerConnection mbeanServer = conn.getMBeanServerConnection();
            JmxUtils.processQueriesForServer(mbeanServer, server);
        }
    }

    public static void printJson(JmxProcess process) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getSerializationConfig().set(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
        System.out.println(mapper.writeValueAsString((Object)process));
    }

    public static void prettyPrintJson(JmxProcess process) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.getSerializationConfig().set(SerializationConfig.Feature.WRITE_NULL_MAP_VALUES, false);
        ObjectWriter writer = mapper.defaultPrettyPrintingWriter();
        System.out.println(writer.writeValueAsString((Object)process));
    }

    public static JmxProcess getJmxProcess(File file) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JmxProcess jmx = (JmxProcess)mapper.readValue(file, JmxProcess.class);
        jmx.setName(file.getName());
        return jmx;
    }

    public static boolean isNumeric(Object value) {
        return value instanceof Number || value instanceof String && JmxUtils.isNumeric((String)value);
    }

    public static boolean isNumeric(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str != null;
        }
        int decimals = 0;
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            char cat = str.charAt(i);
            if (cat == '.' && ++decimals == 1 || Character.isDigit(cat)) continue;
            return false;
        }
        return decimals < str.length();
    }

    public static Map<String, KeyedObjectPool> getDefaultPoolMap() {
        HashMap<String, KeyedObjectPool> poolMap = new HashMap<String, KeyedObjectPool>();
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new SocketFactory());
        pool.setTestOnBorrow(true);
        pool.setMaxActive(-1);
        pool.setMaxIdle(-1);
        pool.setTimeBetweenEvictionRunsMillis(300000L);
        pool.setMinEvictableIdleTimeMillis(300000L);
        poolMap.put(Server.SOCKET_FACTORY_POOL, (KeyedObjectPool)pool);
        GenericKeyedObjectPool jmxPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new JmxConnectionFactory());
        jmxPool.setTestOnBorrow(true);
        jmxPool.setMaxActive(-1);
        jmxPool.setMaxIdle(-1);
        jmxPool.setTimeBetweenEvictionRunsMillis(300000L);
        jmxPool.setMinEvictableIdleTimeMillis(300000L);
        poolMap.put(Server.JMX_CONNECTION_FACTORY_POOL, (KeyedObjectPool)jmxPool);
        GenericKeyedObjectPool dsPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new DatagramSocketFactory());
        dsPool.setTestOnBorrow(true);
        dsPool.setMaxActive(-1);
        dsPool.setMaxIdle(-1);
        dsPool.setTimeBetweenEvictionRunsMillis(300000L);
        dsPool.setMinEvictableIdleTimeMillis(300000L);
        poolMap.put(Server.DATAGRAM_SOCKET_FACTORY_POOL, (KeyedObjectPool)dsPool);
        return poolMap;
    }

    public static String getKeyString(Query query, Result result, Map.Entry<String, Object> values, List<String> typeNames, String rootPrefix) {
        String keyStr = null;
        keyStr = values.getKey().startsWith(result.getAttributeName()) ? values.getKey() : result.getAttributeName() + "." + values.getKey();
        String alias = null;
        if (query.getServer().getAlias() != null) {
            alias = query.getServer().getAlias();
        } else {
            alias = query.getServer().getHost() + "_" + query.getServer().getPort();
            alias = JmxUtils.cleanupStr(alias);
        }
        StringBuilder sb = new StringBuilder();
        if (rootPrefix != null) {
            sb.append(rootPrefix);
            sb.append(".");
        }
        sb.append(alias);
        sb.append(".");
        if (result.getClassNameAlias() != null) {
            sb.append(result.getClassNameAlias());
        } else {
            sb.append(JmxUtils.cleanupStr(result.getClassName()));
        }
        sb.append(".");
        String typeName = JmxUtils.cleanupStr(JmxUtils.getConcatedTypeNameValues(query, typeNames, result.getTypeName()));
        if (typeName != null) {
            sb.append(typeName);
            sb.append(".");
        }
        sb.append(JmxUtils.cleanupStr(keyStr));
        return sb.toString();
    }

    public static String getKeyString2(Query query, Result result, Map.Entry<String, Object> values, List<String> typeNames, String rootPrefix) {
        String keyStr = null;
        keyStr = values.getKey().startsWith(result.getAttributeName()) ? values.getKey() : result.getAttributeName() + "." + values.getKey();
        StringBuilder sb = new StringBuilder();
        if (result.getClassNameAlias() != null) {
            sb.append(result.getClassNameAlias());
        } else {
            sb.append(JmxUtils.cleanupStr(result.getClassName()));
        }
        sb.append(".");
        String typeName = JmxUtils.cleanupStr(JmxUtils.getConcatedTypeNameValues(query, typeNames, result.getTypeName()));
        if (typeName != null) {
            sb.append(typeName);
            sb.append(".");
        }
        sb.append(JmxUtils.cleanupStr(keyStr));
        return sb.toString();
    }

    public static String cleanupStr(String name) {
        if (name == null) {
            return null;
        }
        String clean = name.replace(".", "_");
        clean = clean.replace(" ", "");
        clean = clean.replace("\"", "");
        clean = clean.replace("'", "");
        return clean;
    }

    public static String getConcatedTypeNameValues(List<String> typeNames, String typeNameStr) {
        if (typeNames == null || typeNames.size() == 0) {
            return null;
        }
        String[] tokens = typeNameStr.split(",");
        StringBuilder sb = new StringBuilder();
        for (String key : typeNames) {
            String result = JmxUtils.getTypeNameValue(key, tokens);
            if (result == null) continue;
            sb.append(result);
            sb.append("_");
        }
        return StringUtils.chomp((String)sb.toString(), (String)"_");
    }

    public static String getConcatedTypeNameValues(Query query, List<String> typeNames, String typeName) {
        Set<String> queryTypeNames = query.getTypeNames();
        if (queryTypeNames != null && queryTypeNames.size() > 0) {
            ArrayList<String> allNames = new ArrayList<String>(queryTypeNames);
            for (String name : typeNames) {
                if (allNames.contains(name)) continue;
                allNames.add(name);
            }
            return JmxUtils.getConcatedTypeNameValues(allNames, typeName);
        }
        return JmxUtils.getConcatedTypeNameValues(typeNames, typeName);
    }

    private static String getTypeNameValue(String typeName, String[] tokens) {
        boolean foundIt = false;
        for (String token : tokens) {
            String[] keys;
            for (String key : keys = token.split("=")) {
                if (foundIt) {
                    return key;
                }
                if (!typeName.equals(key)) continue;
                foundIt = true;
            }
        }
        return null;
    }

    public static class ProcessServerThread
    implements Runnable {
        private Server server;
        private JMXConnector conn;

        public ProcessServerThread(Server server, JMXConnector conn) {
            this.server = server;
            this.conn = conn;
        }

        @Override
        public void run() {
            try {
                JmxUtils.processServer(this.server, this.conn);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class ProcessQueryThread
    implements Runnable {
        private MBeanServerConnection mbeanServer;
        private Query query;

        public ProcessQueryThread(MBeanServerConnection mbeanServer, Query query) {
            this.mbeanServer = mbeanServer;
            this.query = query;
        }

        @Override
        public void run() {
            try {
                JmxUtils.processQuery(this.mbeanServer, this.query);
            }
            catch (Exception e) {
                log.error("Error executing query", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

