/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmxtrans.model.output;

import com.googlecode.jmxtrans.model.Query;
import com.googlecode.jmxtrans.model.Result;
import com.googlecode.jmxtrans.model.Server;
import com.googlecode.jmxtrans.util.BaseOutputWriter;
import com.googlecode.jmxtrans.util.JmxUtils;
import com.googlecode.jmxtrans.util.ValidationException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.apache.commons.pool.KeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphiteWriter
extends BaseOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(GraphiteWriter.class);
    public static final String ROOT_PREFIX = "rootPrefix";
    private String host;
    private Integer port;
    private String rootPrefix = "servers";
    private Map<String, KeyedObjectPool> poolMap;
    private KeyedObjectPool pool;
    private InetSocketAddress address;

    public GraphiteWriter() {
        this.poolMap = JmxUtils.getDefaultPoolMap();
    }

    public GraphiteWriter(Map<String, KeyedObjectPool> poolMap) {
        this.poolMap = poolMap;
    }

    @Override
    public void validateSetup(Query query) throws ValidationException {
        this.host = (String)this.getSettings().get("host");
        Object portObj = this.getSettings().get("port");
        if (portObj instanceof String) {
            this.port = Integer.parseInt((String)portObj);
        } else if (portObj instanceof Integer) {
            this.port = (Integer)portObj;
        }
        if (this.host == null || this.port == null) {
            throw new ValidationException("Host and port can't be null", query);
        }
        String rootPrefixTmp = (String)this.getSettings().get(ROOT_PREFIX);
        if (rootPrefixTmp != null) {
            this.rootPrefix = rootPrefixTmp;
        }
        this.address = new InetSocketAddress(this.host, (int)this.port);
        this.pool = this.poolMap.get(Server.SOCKET_FACTORY_POOL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWrite(Query query) throws Exception {
        Socket socket = (Socket)this.pool.borrowObject((Object)this.address);
        try {
            PrintWriter writer = new PrintWriter(socket.getOutputStream(), true);
            List<String> typeNames = this.getTypeNames();
            for (Result result : query.getResults()) {
                Map<String, Object> resultValues;
                if (this.isDebugEnabled()) {
                    log.debug(result.toString());
                }
                if ((resultValues = result.getValues()) == null) continue;
                for (Map.Entry<String, Object> values : resultValues.entrySet()) {
                    if (!JmxUtils.isNumeric(values.getValue())) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append(JmxUtils.getKeyString(query, result, values, typeNames, this.rootPrefix));
                    sb.append(" ");
                    sb.append(values.getValue());
                    sb.append(" ");
                    sb.append(result.getEpoch() / 1000L);
                    sb.append("\n");
                    String line = sb.toString();
                    if (this.isDebugEnabled()) {
                        log.debug("Graphite Message: " + line.trim());
                    }
                    writer.write(line);
                    writer.flush();
                }
            }
        }
        finally {
            this.pool.returnObject((Object)this.address, (Object)socket);
        }
    }

    @Override
    public void setObjectPoolMap(Map<String, KeyedObjectPool> poolMap) {
        this.poolMap = poolMap;
    }
}

